from module_constants import *
from ID_factions import *
from header_items import  *
from header_operations import *
from header_triggers import *

####################################################################################################################
#  Each item record contains the following fields:
#  1) Item id: used for referencing items in other files.
#     The prefix itm_ is automatically added before each item id.
#  2) Item name. Name of item as it'll appear in inventory window
#  3) List of meshes.  Each mesh record is a tuple containing the following fields:
#    3.1) Mesh name.
#    3.2) Modifier bits that this mesh matches.
#     Note that the first mesh record is the default.
#  4) Item flags. See header_items.py for a list of available flags.
#  5) Item capabilities. Used for which animations this item is used with. See header_items.py for a list of available flags.
#  6) Item value.
#  7) Item stats: Bitwise-or of various stats about the item such as:
#      weight, abundance, difficulty, head_armor, body_armor,leg_armor, etc...
#  8) Modifier bits: Modifiers that can be applied to this item.
#  9) [Optional] Triggers: List of simple triggers to be associated with the item.
#  10) [Optional] Factions: List of factions that item can be found as merchandise.
####################################################################################################################

# Some constants for ease of use.
imodbits_none = 0
imodbits_horse_basic = 0 ## CC
imodbits_cloth  = 0
imodbits_armor  = 0
imodbits_plate  = 0
imodbits_polearm = 0
imodbits_shield  = 0
imodbits_sword   = 0
imodbits_sword_high   = 0
imodbits_axe   = 0
imodbits_mace   = 0
imodbits_pick   = 0
imodbits_bow = 0
imodbits_crossbow = 0
imodbits_missile   = 0
imodbits_thrown   = 0
imodbits_thrown_minus_heavy = 0
imodbits_horse_good = 0
imodbits_good   = 0
imodbits_bad    = 0


## CC
missile_distance_trigger = [
  (ti_on_missile_hit, 
    [
      (store_trigger_param_1, ":shooter_agent"),
      
      (eq, "$g_report_shot_distance", 1),
      (get_player_agent_no, ":player_agent"),
      (try_begin),
        (eq, ":shooter_agent", ":player_agent"),
        (agent_get_position, pos2, ":shooter_agent"),
        (agent_get_horse, ":horse_agent", ":player_agent"),
        (try_begin),
          (gt, ":horse_agent", -1),
          (position_move_z, pos2, 220),
        (else_try),
          (position_move_z, pos2, 150),
        (try_end),
        (get_distance_between_positions, ":distance", pos1, pos2),
        (store_div, reg61, ":distance", 100),
        (store_mod, reg62, ":distance", 100),
        (try_begin),
          (lt, reg62, 10),
          (str_store_string, s1, "@{reg61}.0{reg62}"),
        (else_try),
          (str_store_string, s1, "@{reg61}.{reg62}"),
        (try_end),
        (display_message, "@Shot distance: {s1} meters.", 0xCCCCCC),
      (try_end),
    ])]    
## CC


# Replace winged mace/spiked mace with: Flanged mace / Knobbed mace?
# Fauchard (majowski glaive)
items = [
# item_name, mesh_name, item_properties, item_capabilities, slot_no, cost, bonus_flags, weapon_flags, scale, view_dir, pos_offset
 ["no_item","INVALID ITEM", [("invalid_item",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary, itc_longsword, 3,weight(1.5)|spd_rtng(103)|weapon_length(90)|swing_damage(16,blunt)|thrust_damage(10,blunt),imodbits_none],

 ["tutorial_spear", "Spear", [("saracin_spears_a",0)], itp_type_polearm| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_spear, 0 , weight(4.5)|difficulty(0)|spd_rtng(80) | weapon_length(158)|swing_damage(0 , cut) | thrust_damage(19 ,  pierce),imodbits_polearm ],
 ["tutorial_club", "Club", [("club",0)], itp_type_one_handed_wpn| itp_primary|itp_wooden_parry|itp_wooden_attack, itc_scimitar, 0 , weight(2.5)|difficulty(0)|spd_rtng(95) | weapon_length(95)|swing_damage(11 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],
 ["tutorial_battle_axe", "Battle Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_nodachi|itcf_carry_axe_back, 0 , weight(5)|difficulty(0)|spd_rtng(88) | weapon_length(108)|swing_damage(27 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
 ["tutorial_arrows","Arrows", [("arrow_tyrk_a",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_a", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back, 0,weight(3)|abundance(160)|weapon_length(95)|thrust_damage(0,pierce)|max_ammo(20),imodbits_missile,missile_distance_trigger],
 ["tutorial_bolts","Bolts", [("crusade_bolt",0),("flying_missile",ixmesh_flying_ammo),("crusade_bolt_bag", ixmesh_carry),("bolt_bag_b", ixmesh_carry|imodbit_large_bag)], itp_type_bolts, itcf_carry_quiver_right_vertical, 0,weight(2.25)|abundance(90)|weapon_length(55)|thrust_damage(0,pierce)|max_ammo(18),imodbits_missile,missile_distance_trigger],
 ["tutorial_short_bow", "Short Bow", [("saracin_bow_b",0),("saracin_bow_case_b",ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bow_back, 0 , weight(1)|difficulty(0)|spd_rtng(98) | shoot_speed(49) | thrust_damage(12 ,  pierce  ),imodbits_bow ],
 ["tutorial_crossbow", "Crossbow", [("crusaders_crossbows_b",0)], itp_type_crossbow |itp_primary|itp_two_handed|itp_cant_reload_on_horseback ,itcf_shoot_crossbow, 0 , weight(3)|difficulty(0)|spd_rtng(42)|  shoot_speed(68) | thrust_damage(32,pierce)|max_ammo(1),imodbits_crossbow ],
 ["tutorial_throwing_daggers", "Throwing Daggers", [("throwing_dagger",0)], itp_type_thrown |itp_primary ,itcf_throw_knife, 0 , weight(3.5)|difficulty(0)|spd_rtng(102) | shoot_speed(25) | thrust_damage(16 ,  cut)|max_ammo(14)|weapon_length(0),imodbits_missile,missile_distance_trigger],
 ["tutorial_saddle_horse", "Horse", [("horse_bandits_a",0)], itp_type_horse, 0, 0,abundance(90)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["tutorial_shield", "Kite Shield", [("shield_kite_a",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|weapon_length(150),imodbits_shield ],
 ["tutorial_staff_no_attack","Staff", [("wooden_staff",0)],itp_type_polearm|itp_offset_lance|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_wooden_attack,itc_parry_polearm|itcf_carry_sword_back,9, weight(3.5)|spd_rtng(120) | weapon_length(115)|swing_damage(0,blunt) | thrust_damage(0,blunt),imodbits_none],
 ["tutorial_staff","Staff", [("wooden_staff",0)],itp_type_polearm|itp_offset_lance|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_wooden_attack,itc_staff|itcf_carry_sword_back,9, weight(3.5)|spd_rtng(120) | weapon_length(115)|swing_damage(16,blunt) | thrust_damage(16,blunt),imodbits_none],
 ["tutorial_sword", "Sword", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 0 , weight(1.5)|difficulty(0)|spd_rtng(100) | weapon_length(102)|swing_damage(18 , cut) | thrust_damage(15 ,  pierce),imodbits_sword ],
 ["tutorial_axe", "Axe", [("axe_crusader_a",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_nodachi|itcf_carry_axe_back, 0 , weight(4)|difficulty(0)|spd_rtng(91) | weapon_length(108)|swing_damage(19 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
 ["tutorial_dagger","Dagger", [("practice_dagger",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary, itc_longsword, 3,weight(1.5)|spd_rtng(103)|weapon_length(40)|swing_damage(16,blunt)|thrust_damage(10,blunt),imodbits_none],
 ["horse_meat","Horse Meat", [("raw_meat",0)], itp_type_goods|itp_consumable|itp_food, 0, 12,weight(40)|food_quality(30)|max_ammo(40),imodbits_none],
# Items before this point are hardwired and their order should not be changed!

 ["practice_sword","Practice Sword", [("practice_sword",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary|itp_wooden_parry|itp_wooden_attack, itc_longsword, 3,weight(1.5)|spd_rtng(103)|weapon_length(90)|swing_damage(22,blunt)|thrust_damage(20,blunt),imodbits_none],
 ["heavy_practice_sword","Heavy Practice Sword", [("heavy_practicesword",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary|itp_wooden_parry|itp_wooden_attack, itc_greatsword,
    21, weight(6.25)|spd_rtng(94)|weapon_length(128)|swing_damage(30,blunt)|thrust_damage(24,blunt),imodbits_none],
 ["practice_dagger","Practice Dagger", [("practice_dagger",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary|itp_no_parry|itp_wooden_attack, itc_dagger|itcf_carry_dagger_front_left, 2,weight(0.5)|spd_rtng(110)|weapon_length(47)|swing_damage(16,blunt)|thrust_damage(14,blunt),imodbits_none],
 ["practice_axe", "Practice Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip, 24 , weight(2) | spd_rtng(95) | weapon_length(75) | swing_damage(24, blunt) | thrust_damage(0, pierce), imodbits_axe],
 ["arena_axe", "Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip,
 137 , weight(1.5)|spd_rtng(100) | weapon_length(69)|swing_damage(24 , blunt) | thrust_damage(0 ,  pierce),imodbits_axe ],
 ["arena_sword", "Sword", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry),], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,
 243 , weight(1.5)|spd_rtng(99) | weapon_length(95)|swing_damage(22 , blunt) | thrust_damage(20 ,  blunt),imodbits_sword_high ],
 ["arena_sword_two_handed",  "Two Handed Sword", [("crusader_long_sword_c",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary, itc_greatsword|itcf_carry_sword_back,
 670 , weight(2.75)|spd_rtng(93) | weapon_length(110)|swing_damage(30 , blunt) | thrust_damage(24 ,  blunt),imodbits_sword_high ],
 ["arena_lance",         "Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_staff|itcf_carry_spear,
 90 , weight(2.5)|spd_rtng(96) | weapon_length(150)|swing_damage(20 , blunt) | thrust_damage(25 ,  blunt),imodbits_polearm ],
 ["practice_staff","Practice Staff", [("wooden_staff",0)],itp_type_polearm|itp_offset_lance|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_wooden_attack,itc_staff|itcf_carry_sword_back,9, weight(2.5)|spd_rtng(103) | weapon_length(118)|swing_damage(18,blunt) | thrust_damage(18,blunt),imodbits_none],
 ["practice_lance","Practice Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_wooden_attack, itc_greatlance, 18,weight(4.25)|spd_rtng(58)|weapon_length(240)|swing_damage(0,blunt)|thrust_damage(15,blunt),imodbits_none],
 ["practice_shield","Practice Shield", [("saracin_shield_s",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 20,weight(3.5)|body_armor(1)|hit_points(200)|spd_rtng(100)|shield_width(50),imodbits_none],
 ["practice_bow","Practice Bow", [("saracin_bow_b",0), ("saracin_bow_case_b",ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bow_back, 0, weight(1.5)|spd_rtng(90) | shoot_speed(40) | thrust_damage(21, blunt),imodbits_bow ],
 ["practice_crossbow", "Practice Crossbow", [("crusaders_crossbows_b",0)], itp_type_crossbow |itp_primary|itp_two_handed ,itcf_shoot_crossbow, 0, weight(3)|spd_rtng(42)| shoot_speed(68) | thrust_damage(32,blunt)|max_ammo(1),imodbits_crossbow],
 ["practice_javelin", "Practice Javelins", [("jarid_new_b",0),("jarid_new_b_bag", ixmesh_carry)], itp_type_thrown |itp_primary|itp_next_item_as_melee,itcf_throw_javelin|itcf_carry_quiver_back|itcf_show_holster_when_drawn, 0, weight(5) | spd_rtng(91) | shoot_speed(28) | thrust_damage(27, blunt) | max_ammo(50) | weapon_length(75), imodbits_thrown,missile_distance_trigger], ## CC
 ["practice_javelin_melee", "Practice_javelin_melee", [("jarid_new_b",0)], itp_type_polearm|itp_primary|itp_penalty_with_shield|itp_wooden_parry , itc_staff, 0, weight(1)|difficulty(0)|spd_rtng(91) |swing_damage(12, blunt)| thrust_damage(14,  blunt)|weapon_length(75),imodbits_polearm ],
 ["practice_throwing_daggers", "Throwing Daggers", [("throwing_dagger",0)], itp_type_thrown |itp_primary ,itcf_throw_knife, 0 , weight(3.5)|spd_rtng(102) | shoot_speed(25) | thrust_damage(16, blunt)|max_ammo(10)|weapon_length(0),imodbits_thrown,missile_distance_trigger], ## CC
 ["practice_throwing_daggers_100_amount", "Throwing Daggers", [("throwing_dagger",0)], itp_type_thrown |itp_primary ,itcf_throw_knife, 0 , weight(3.5)|spd_rtng(102) | shoot_speed(25) | thrust_damage(16, blunt)|max_ammo(100)|weapon_length(0),imodbits_thrown,missile_distance_trigger], ## CC
 ["practice_horse","Practice Horse", [("horse_bandits_a",0)], itp_type_horse, 0, 37,hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["practice_arrows","Practice Arrows", [("arrow_tyrk_a",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_a", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back, 0,weight(1.5)|weapon_length(95)|max_ammo(80),imodbits_missile,missile_distance_trigger], ## CC
 ["practice_bolts","Practice Bolts", [("crusade_bolt",0),("flying_missile",ixmesh_flying_ammo),("crusade_bolt_bag", ixmesh_carry),("bolt_bag_b", ixmesh_carry|imodbit_large_bag)], itp_type_bolts, itcf_carry_quiver_right_vertical, 0,weight(2.25)|weapon_length(55)|max_ammo(49),imodbits_missile,missile_distance_trigger], ## CC
 ["practice_arrows_10_amount","Practice Arrows", [("arrow_tyrk_a",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_a", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back, 0,weight(1.5)|weapon_length(95)|max_ammo(10),imodbits_missile,missile_distance_trigger], ## CC
 ["practice_arrows_100_amount","Practice Arrows", [("arrow_tyrk_a",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_a", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back, 0,weight(1.5)|weapon_length(95)|max_ammo(100),imodbits_missile,missile_distance_trigger], ## CC
 ["practice_bolts_9_amount","Practice Bolts", [("crusade_bolt",0),("flying_missile",ixmesh_flying_ammo),("crusade_bolt_bag", ixmesh_carry),("bolt_bag_b", ixmesh_carry|imodbit_large_bag)], itp_type_bolts, itcf_carry_quiver_right_vertical, 0,weight(2.25)|weapon_length(55)|max_ammo(9),imodbits_missile,missile_distance_trigger], ## CC
 ["practice_boots", "Practice Boots", [("boot_light_crusader_c",0)], itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 11 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(10), imodbits_cloth ],

 ["red_tourney_armor","Red Tourney Armor", [("sargento_perpunt2",0)], itp_type_body_armor|itp_covers_legs, 0, 152,weight(15.0)|body_armor(20)|leg_armor(6),imodbits_none],
 ["blue_tourney_armor","Blue Tourney Armor", [("sargento_perpunt1",0)], itp_type_body_armor|itp_covers_legs, 0, 152,weight(15.0)|body_armor(20)|leg_armor(6),imodbits_none],
 ["green_tourney_armor","Green Tourney Armor", [("sargento_perpunt5",0)], itp_type_body_armor|itp_covers_legs, 0, 152,weight(15.0)|body_armor(20)|leg_armor(6),imodbits_none],
 ["gold_tourney_armor","Gold Tourney Armor", [("sargento_perpunt3",0)], itp_type_body_armor|itp_covers_legs, 0, 152,weight(15.0)|body_armor(20)|leg_armor(6),imodbits_none],
 ["red_tourney_helmet","Red Tourney Helmet",[("light_crusader_helm_a",0)],itp_type_head_armor|itp_covers_beard,0,126, weight(2)|head_armor(16),imodbits_none],
 ["blue_tourney_helmet","Blue Tourney Helmet",[("light_crusader_helm_a",0)],itp_type_head_armor|itp_covers_beard,0,126, weight(2)|head_armor(16),imodbits_none],
 ["green_tourney_helmet","Green Tourney Helmet",[("light_crusader_helm_a",0)],itp_type_head_armor|itp_covers_beard,0,126, weight(2)|head_armor(16),imodbits_none],
 ["gold_tourney_helmet","Gold Tourney Helmet",[("light_crusader_helm_a",0)],itp_type_head_armor|itp_covers_beard,0,126, weight(2)|head_armor(16),imodbits_none],

["arena_shield_red", "Shield", [("escut_roig",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  42 , weight(2)|hit_points(360)|body_armor(1)|spd_rtng(100)|weapon_length(60),imodbits_shield ],
["arena_shield_blue", "Shield", [("escut_blau",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  42 , weight(2)|hit_points(360)|body_armor(1)|spd_rtng(100)|weapon_length(60),imodbits_shield ],
["arena_shield_green", "Shield", [("escut_vert",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  42 , weight(2)|hit_points(360)|body_armor(1)|spd_rtng(100)|weapon_length(60),imodbits_shield ],
["arena_shield_yellow", "Shield", [("escut_groc",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  42 , weight(2)|hit_points(360)|body_armor(1)|spd_rtng(100)|weapon_length(60),imodbits_shield ],

["arena_armor_white", "Arena Armor White", [("sargento_perpunt4",0)], itp_type_body_armor  |itp_covers_legs ,0, 650 , weight(16)|abundance(100)|head_armor(0)|body_armor(29)|leg_armor(13), imodbits_armor ],
["arena_armor_red", "Arena Armor Red", [("sargento_perpunt2",0)], itp_type_body_armor  |itp_covers_legs ,0, 650 , weight(16)|abundance(100)|head_armor(0)|body_armor(29)|leg_armor(13), imodbits_armor ],
["arena_armor_blue", "Arena Armor Blue", [("sargento_perpunt1",0)], itp_type_body_armor  |itp_covers_legs ,0, 650 , weight(16)|abundance(100)|head_armor(0)|body_armor(29)|leg_armor(13), imodbits_armor ],
["arena_armor_green", "Arena Armor Green", [("sargento_perpunt5",0)], itp_type_body_armor  |itp_covers_legs ,0, 650 , weight(16)|abundance(100)|head_armor(0)|body_armor(29)|leg_armor(13), imodbits_armor ],
["arena_armor_yellow", "Arena Armor Yellow", [("sargento_perpunt3",0)], itp_type_body_armor  |itp_covers_legs ,0, 650 , weight(16)|abundance(100)|head_armor(0)|body_armor(29)|leg_armor(13), imodbits_armor ],
["arena_tunic_white", "Arena Tunic White ", [("sargento_perpunt4",0)], itp_type_body_armor |itp_covers_legs ,0, 47 , weight(2)|abundance(100)|head_armor(0)|body_armor(16)|leg_armor(6), imodbits_cloth ],
["arena_tunic_red", "Arena Tunic Red", [("sargento_perpunt2",0)], itp_type_body_armor |itp_covers_legs ,0, 27 , weight(2)|abundance(100)|head_armor(0)|body_armor(16)|leg_armor(6), imodbits_cloth ],
["arena_tunic_blue", "Arena Tunic Blue", [("sargento_perpunt1",0)], itp_type_body_armor |itp_covers_legs ,0, 27 , weight(2)|abundance(100)|head_armor(0)|body_armor(16)|leg_armor(6), imodbits_cloth ],
["arena_tunic_green", "Arena Tunic Green", [("sargento_perpunt5",0)], itp_type_body_armor |itp_covers_legs ,0, 27 , weight(2)|abundance(100)|head_armor(0)|body_armor(16)|leg_armor(6), imodbits_cloth ],
["arena_tunic_yellow", "Arena Tunic Yellow", [("sargento_perpunt3",0)], itp_type_body_armor |itp_covers_legs ,0, 27 , weight(2)|abundance(100)|head_armor(0)|body_armor(16)|leg_armor(6), imodbits_cloth ],

#headwear
["arena_helmet_red", "Arena Helmet Red", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(26)|body_armor(0)|leg_armor(0), imodbits_armor ],
["arena_helmet_blue", "Arena Helmet Blue", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(26)|body_armor(0)|leg_armor(0), imodbits_armor ],
["arena_helmet_green", "Arena Helmet Green", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(26)|body_armor(0)|leg_armor(0), imodbits_armor ],
["arena_helmet_yellow", "Arena Helmet Yellow", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(26)|body_armor(0)|leg_armor(0), imodbits_armor ],
["steppe_helmet_white", "Steppe Helmet White", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0), imodbits_armor ],
["steppe_helmet_red", "Steppe Helmet Red", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0), imodbits_armor ],
["steppe_helmet_blue", "Steppe Helmet Blue", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0), imodbits_armor ],
["steppe_helmet_green", "Steppe Helmet Green", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0), imodbits_armor ],
["steppe_helmet_yellow", "Steppe Helmet Yellow", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0), imodbits_armor ],
["tourney_helm_white", "Tourney Helmet White", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard,0, 760 , weight(2.75)|abundance(100)|head_armor(30)|body_armor(0)|leg_armor(0), imodbits_armor ],
["tourney_helm_red", "Tourney Helmet Red", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard,0, 760 , weight(2.75)|abundance(100)|head_armor(30)|body_armor(0)|leg_armor(0), imodbits_armor ],
["tourney_helm_blue", "Tourney Helmet Blue", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard,0, 760 , weight(2.75)|abundance(100)|head_armor(30)|body_armor(0)|leg_armor(0), imodbits_armor ],
["tourney_helm_green", "Tourney Helmet Green", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard,0, 760 , weight(2.75)|abundance(100)|head_armor(30)|body_armor(0)|leg_armor(0), imodbits_armor ],
["tourney_helm_yellow", "Tourney Helmet Yellow", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard,0, 760 , weight(2.75)|abundance(100)|head_armor(30)|body_armor(0)|leg_armor(0), imodbits_armor ],
["arena_turban_red", "Arena Helmet Red", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(26)|body_armor(0)|leg_armor(0), imodbits_armor ],
["arena_turban_blue", "Arena Helmet Blue", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(26)|body_armor(0)|leg_armor(0), imodbits_armor ],
["arena_turban_green", "Arena Helmet Green", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(26)|body_armor(0)|leg_armor(0), imodbits_armor ],
["arena_turban_yellow", "Arena Helmet Yellow", [("light_crusader_helm_a",0)], itp_type_head_armor|itp_covers_beard ,0, 187 , weight(1.25)|abundance(100)|head_armor(26)|body_armor(0)|leg_armor(0), imodbits_armor ],


# BOOKS 
## Skill books
## This book must be at the beginning of readable books
# ["book_tactics","De Re Militari", [("book_a",0)], itp_type_book, 0, 4000,weight(2)|abundance(30),imodbits_none],
# ["book_persuasion","Rhetorica ad Herennium", [("book_b",0)], itp_type_book, 0, 5000,weight(2)|abundance(30),imodbits_none],
# ["book_leadership","The Life of Alixenus the Great", [("book_d",0)], itp_type_book, 0, 4200,weight(2)|abundance(30),imodbits_none],
# ["book_intelligence","Essays on Logic", [("book_e",0)], itp_type_book, 0, 2900,weight(2)|abundance(30),imodbits_none],
# ["book_prisoner_management","Ramun's Notes", [("book_a",0)], itp_type_book, 0, 5000,weight(2)|abundance(30),imodbits_none], ## CC
# ["book_trade","A Treatise on the Value of Things", [("book_f",0)], itp_type_book, 0, 3100,weight(2)|abundance(30),imodbits_none],
# ["book_weapon_mastery", "On the Art of Fighting with Swords", [("book_d",0)], itp_type_book, 0, 4200,weight(2)|abundance(30),imodbits_none],
# ["book_engineering","Method of Mechanical Theorems", [("book_open",0)], itp_type_book, 0, 4000,weight(2)|abundance(30),imodbits_none],
 
 ["book_tactics","De Re Militari", [("bk_book_01",0)], itp_type_book, 0, 4000,weight(2)|abundance(30),imodbits_none],
 ["book_persuasion","Rhetorica ad Herennium", [("bk_book_02",0)], itp_type_book, 0, 5000,weight(2)|abundance(30),imodbits_none],
 ["book_leadership","The Life of Alixenus the Great", [("bk_book_03",0)], itp_type_book, 0, 4200,weight(2)|abundance(30),imodbits_none],
 ["book_intelligence","Essays on Logic", [("bk_book_04",0)], itp_type_book, 0, 2900,weight(2)|abundance(30),imodbits_none],
 ["book_prisoner_management","Ramun's Notes", [("bk_book_11",0)], itp_type_book, 0, 5000,weight(2)|abundance(30),imodbits_none], ## CC
 ["book_trade","A Treatise on the Value of Things", [("bk_book_05",0)], itp_type_book, 0, 3100,weight(2)|abundance(30),imodbits_none],
 ["book_weapon_mastery", "On the Art of Fighting with Swords", [("bk_book_06",0)], itp_type_book, 0, 4200,weight(2)|abundance(30),imodbits_none],
 ["book_engineering","Method of Mechanical Theorems", [("bk_book_07",0)], itp_type_book, 0, 4000,weight(2)|abundance(30),imodbits_none],

 ["book_treasure_map","Map to the Ark of the Covenant", [("bk_book_05",0)], itp_merchandise|itp_type_book, 0, 1000,weight(2)|abundance(10),imodbits_none], 
 
## Reference books
## This book must be at the beginning of reference books
 ["book_wound_treatment_reference","The Book of Healing", [("bk_book_08",0)], itp_type_book, 0, 3500,weight(2)|abundance(100),imodbits_none],
 ["book_training_reference","Manual of Arms", [("bk_book_09",0)], itp_type_book, 0, 3500,weight(2)|abundance(100),imodbits_none],
 ["book_surgery_reference","The Great Book of Surgery", [("bk_book_10",0)], itp_type_book, 0, 3500,weight(2)|abundance(100),imodbits_none],
 ["book_trade_ledger","Merchant's Ledger", [("bk_book_05",0)], itp_type_book, 0, 3500,weight(2)|abundance(100),imodbits_none], ## Merchant's Trade Ledger
## CC
 ["book_spotting_reference","Quran", [("bk_book_05",0)], itp_type_book, 0, 3500,weight(2)|abundance(30),imodbits_none],
 ["book_first_aid_reference","The General Knowledge of First Aid", [("bk_book_10",0)], itp_type_book, 0, 3500,weight(2)|abundance(30),imodbits_none],
 ["book_pathfinding_reference","Holy Bible", [("bk_book_16",0)], itp_type_book, 0, 3500,weight(2)|abundance(30),imodbits_none],
## CC

# TRADE GOODS
## other trade goods (first one is spice)
 ["spice","Spice", [("spice_sack",0)], itp_merchandise|itp_type_goods|itp_consumable, 0, 880,weight(40)|abundance(25)|max_ammo(50),imodbit_fine|imodbit_large_bag|imodbit_exquisite],
 ["salt","Salt", [("salt_sack",0)], itp_merchandise|itp_type_goods, 0, 255,weight(50)|abundance(120),imodbit_fine|imodbit_large_bag],
 ["oil","Oil", [("oil",0)], itp_merchandise|itp_type_goods|itp_consumable, 0, 450,weight(50)|abundance(60)|max_ammo(50),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite],
 ["pottery","Pottery", [("jug",0)], itp_merchandise|itp_type_goods, 0, 100,weight(50)|abundance(90),imodbit_cracked|imodbit_crude|imodbit_old|imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite|imodbit_masterwork|imodbit_rough|imodbit_sturdy],
 ["raw_flax","Flax Bundle", [("raw_flax",0)], itp_merchandise|itp_type_goods, 0, 150,weight(40)|abundance(90),imodbit_fine|imodbit_exquisite],
 ["linen","Linen", [("linen",0)], itp_merchandise|itp_type_goods, 0, 250,weight(40)|abundance(90),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite|imodbit_masterwork|imodbit_tattered|imodbit_ragged|imodbit_rough|imodbit_sturdy],
 ["wool","Wool", [("wool_sack",0)], itp_merchandise|itp_type_goods, 0, 130,weight(40)|abundance(90),imodbit_fine|imodbit_exquisite],
 ["wool_cloth","Wool Cloth", [("wool_cloth",0)], itp_merchandise|itp_type_goods, 0, 250,weight(40)|abundance(90),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite|imodbit_masterwork|imodbit_tattered|imodbit_ragged|imodbit_rough|imodbit_sturdy],
 ["raw_silk","Raw Silk", [("raw_silk_bundle",0)], itp_merchandise|itp_type_goods, 0, 600,weight(30)|abundance(90),imodbit_fine|imodbit_exquisite],
 ["raw_dyes","Dyes", [("dyes",0)], itp_merchandise|itp_type_goods, 0, 200,weight(10)|abundance(90),imodbit_fine|imodbit_well_made|imodbit_exquisite|imodbit_masterwork],
 ["velvet","Velvet", [("velvet",0)], itp_merchandise|itp_type_goods, 0, 1025,weight(40)|abundance(30),imodbit_fine|imodbit_well_made|imodbit_exquisite|imodbit_masterwork],
 ["iron","Iron", [("iron",0)], itp_merchandise|itp_type_goods, 0,264,weight(60)|abundance(60),imodbit_rusty|imodbit_poor|imodbit_well_made|imodbit_tempered|imodbit_hardened],
 ["tools","Tools", [("iron_hammer",0)], itp_merchandise|itp_type_goods, 0, 410,weight(50)|abundance(90),imodbit_rusty|imodbit_crude|imodbit_old|imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite|imodbit_masterwork|imodbit_sturdy|imodbit_hardened],
 ["raw_leather","Hides", [("leatherwork_inventory",0)], itp_merchandise|itp_type_goods, 0, 120,weight(40)|abundance(90),imodbit_fine|imodbit_exquisite|imodbit_tattered|imodbit_ragged|imodbit_sturdy|imodbit_thick],
 ["leatherwork","Leatherwork", [("leatherwork_frame",0)], itp_merchandise|itp_type_goods, 0, 220,weight(40)|abundance(90),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite|imodbit_masterwork|imodbit_tattered|imodbit_ragged|imodbit_rough|imodbit_sturdy|imodbit_thick],
 ["raw_date_fruit","Date Fruit", [("date_inventory",0)], itp_merchandise|itp_consumable|itp_type_goods, 0, 100,weight(40)|abundance(90)|food_quality(10)|max_ammo(10),imodbits_none],
 ["furs","Furs", [("fur_pack",0)], itp_merchandise|itp_type_goods, 0, 391,weight(40)|abundance(90),imodbit_cheap|imodbit_fine|imodbit_exquisite|imodbit_tattered|imodbit_ragged|imodbit_sturdy|imodbit_thick],
 ["wine","Wine", [("amphora_slim",0)], itp_merchandise|itp_type_goods|itp_consumable, 0, 220,weight(30)|abundance(60)|max_ammo(50),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite|imodbit_strong],
 ["ale","Ale", [("ale_barrel",0)], itp_merchandise|itp_type_goods|itp_consumable, 0, 120,weight(30)|abundance(70)|max_ammo(50),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite|imodbit_strong|imodbit_lordly],


# FOOD
## foods (first one is smoked_fish)
## CC
## max_ammo & price x2
 ["smoked_fish","Smoked Fish", [("smoked_fish",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 65,weight(15)|abundance(110)|food_quality(50)|max_ammo(50),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite],
 ["cheese","Cheese", [("cheese_b",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 75,weight(6)|abundance(110)|food_quality(40)|max_ammo(30),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite],
 ["honey","Honey", [("honey_pot",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 220,weight(5)|abundance(110)|food_quality(40)|max_ammo(30),imodbit_cheap|imodbit_fine|imodbit_exquisite],
 ["sausages","Sausages", [("sausages",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 85,weight(10)|abundance(110)|food_quality(40)|max_ammo(40),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite],
 ["cabbages","Cabbages", [("cabbage",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 30,weight(15)|abundance(110)|food_quality(40)|max_ammo(50),imodbit_cheap|imodbit_fine|imodbit_exquisite],
 ["dried_meat","Dried Meat", [("smoked_meat",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 85,weight(15)|abundance(100)|food_quality(70)|max_ammo(50),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite],
 ["apples","Fruit", [("apple_basket",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 44,weight(20)|abundance(110)|food_quality(40)|max_ammo(50),imodbit_cheap|imodbit_fine|imodbit_exquisite],
 ["raw_grapes","Grapes", [("grapes_inventory",0)], itp_merchandise|itp_consumable|itp_type_goods, 0, 75,weight(40)|abundance(90)|food_quality(10)|max_ammo(10),imodbits_none], #x2 for imodbit_cheap|imodbit_fine|imodbit_exquisite
 ["raw_olives","Olives", [("olive_inventory",0)], itp_merchandise|itp_consumable|itp_type_goods, 0, 100,weight(40)|abundance(90)|food_quality(10)|max_ammo(10),imodbits_none], #x3 for imodbit_cheap|imodbit_fine|imodbit_exquisite
 ["grain","Grain", [("wheat_sack",0)], itp_merchandise|itp_type_goods|itp_consumable, 0, 30,weight(30)|abundance(110)|food_quality(40)|max_ammo(50),imodbit_cheap|imodbit_fine|imodbit_exquisite|imodbit_large_bag],
 #["raw_date_fruit","Date Fruit", [("date_inventory",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 240,weight(4)|food_quality(10)|max_ammo(20),imodbits_none], ## CC
 ["cattle_meat","Beef", [("raw_meat",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 80,weight(20)|abundance(100)|food_quality(80)|max_ammo(50),imodbits_none],
 ["bread","Bread", [("bread_a",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 50,weight(30)|abundance(110)|food_quality(40)|max_ammo(50),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite],
 ["chicken","Chicken", [("chicken",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 95,weight(10)|abundance(110)|food_quality(40)|max_ammo(50),imodbits_none],
 ["pork","Pork", [("pork",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 75,weight(15)|abundance(100)|food_quality(70)|max_ammo(50),imodbits_none],
 ["butter","Butter", [("butter_pot",0)], itp_merchandise|itp_type_goods|itp_consumable|itp_food, 0, 150,weight(6)|abundance(110)|food_quality(40)|max_ammo(30),imodbit_cheap|imodbit_fine|imodbit_well_made|imodbit_exquisite],
## CC


 #Would like to remove flour altogether and reduce chicken, pork and butter (perishables) to non-trade items. Apples could perhaps become a generic "fruit", also representing dried fruit and grapes
 # Armagan: changed order so that it'll be easier to remove them from trade goods if necessary.
#************************************************************************************************
# ITEMS before this point are hardcoded into item_codes.h and their order should not be changed!
#************************************************************************************************

# QUEST ITEMS
 ["siege_supply","Supplies", [("ale_barrel",0)], itp_type_goods, 0, 96,weight(40)|abundance(70),imodbits_none],
 ["quest_wine","Wine", [("amphora_slim",0)], itp_type_goods, 0, 46,weight(40)|abundance(60)|max_ammo(50),imodbits_none],
 ["quest_ale","Ale", [("ale_barrel",0)], itp_type_goods, 0, 31,weight(40)|abundance(70)|max_ammo(50),imodbits_none],


# TUTORIAL ITEMS
 ["tutorial_sword", "Sword", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 0 , weight(1.5)|difficulty(0)|spd_rtng(100) | weapon_length(102)|swing_damage(18 , cut) | thrust_damage(15 ,  pierce),imodbits_sword ],
 ["tutorial_axe", "Axe", [("axe_crusader_a",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_nodachi|itcf_carry_axe_back, 0 , weight(4)|difficulty(0)|spd_rtng(91) | weapon_length(108)|swing_damage(19 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
 ["tutorial_spear", "Spear", [("saracin_spears_a",0)], itp_type_polearm| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_spear, 0 , weight(4.5)|difficulty(0)|spd_rtng(80) | weapon_length(158)|swing_damage(0 , cut) | thrust_damage(19 ,  pierce),imodbits_polearm ],
 ["tutorial_club", "Club", [("club",0)], itp_type_one_handed_wpn| itp_primary|itp_wooden_parry|itp_wooden_attack, itc_scimitar, 0 , weight(2.5)|difficulty(0)|spd_rtng(95) | weapon_length(95)|swing_damage(11 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],
 ["tutorial_battle_axe", "Battle Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_nodachi|itcf_carry_axe_back, 0 , weight(5)|difficulty(0)|spd_rtng(88) | weapon_length(108)|swing_damage(27 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
 ["tutorial_arrows","Arrows", [("arrow_tyrk_a",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_a", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back, 0,weight(3)|abundance(160)|weapon_length(95)|thrust_damage(0,pierce)|max_ammo(20),imodbits_missile,missile_distance_trigger], ## CC
 ["tutorial_bolts","Bolts", [("crusade_bolt",0),("flying_missile",ixmesh_flying_ammo),("crusade_bolt_bag", ixmesh_carry),("bolt_bag_b", ixmesh_carry|imodbit_large_bag)], itp_type_bolts, itcf_carry_quiver_right_vertical, 0,weight(2.25)|abundance(90)|weapon_length(63)|thrust_damage(0,pierce)|max_ammo(18),imodbits_missile,missile_distance_trigger], ## CC
 ["tutorial_short_bow", "Short Bow", [("saracin_bow_b",0),("saracin_bow_case_b",ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bow_back, 0 , weight(1)|difficulty(0)|spd_rtng(98) | shoot_speed(49) | thrust_damage(12 ,  pierce  ),imodbits_bow ],
 ["tutorial_crossbow", "Crossbow", [("crusaders_crossbows_b",0)], itp_type_crossbow |itp_primary|itp_two_handed|itp_cant_reload_on_horseback ,itcf_shoot_crossbow, 0 , weight(3)|difficulty(0)|spd_rtng(42)|  shoot_speed(68) | thrust_damage(32,pierce)|max_ammo(1),imodbits_crossbow ],
 ["tutorial_throwing_daggers", "Throwing Daggers", [("throwing_dagger",0)], itp_type_thrown |itp_primary ,itcf_throw_knife, 0 , weight(3.5)|difficulty(0)|spd_rtng(102) | shoot_speed(25) | thrust_damage(16 ,  cut)|max_ammo(14)|weapon_length(0),imodbits_missile,missile_distance_trigger], ## CC
 ["tutorial_saddle_horse", "Horse", [("horse_bandits_a",0)], itp_type_horse, 0, 0,abundance(90)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["tutorial_shield", "Kite Shield", [("shield_kite_a",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|weapon_length(150),imodbits_shield ],
 ["tutorial_staff_no_attack","Staff", [("wooden_staff",0)],itp_type_polearm|itp_offset_lance|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_wooden_attack,itc_parry_polearm|itcf_carry_sword_back,9, weight(3.5)|spd_rtng(120) | weapon_length(115)|swing_damage(0,blunt) | thrust_damage(0,blunt),imodbits_none],
 ["tutorial_staff","Staff", [("wooden_staff",0)],itp_type_polearm|itp_offset_lance|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_wooden_attack,itc_staff|itcf_carry_sword_back,9, weight(3.5)|spd_rtng(120) | weapon_length(115)|swing_damage(16,blunt) | thrust_damage(16,blunt),imodbits_none],


# HORSES
 ["sumpter_horse","Horse", [("horse_light_a",0)], itp_type_horse, 0, 134,abundance(70)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["saddle_horse","Horse", [("horse_light_b",0),("horse_c",imodbits_horse_good)], itp_type_horse, 0, 240,abundance(50)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["steppe_horse","Horse", [("horse_light_c",0)], itp_type_horse, 0, 192,abundance(70)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["arabian_horse_a","Horse", [("horse_light_a",0)], itp_type_horse, 0, 850,abundance(15)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["courser","Horse", [("horse_light_b",0)], itp_type_horse, 0, 600,abundance(50)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["arabian_horse_b","Horse", [("horse_light_c",0)], itp_type_horse, 0, 850,abundance(15)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["hunter","Horse", [("horse_light_a",0)], itp_type_horse, 0, 810,abundance(30)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["warhorse","Horse", [("horse_light_b",0)], itp_type_horse, 0, 1224,abundance(20)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["warhorse_sarranid","Horse", [("horse_light_c",0)], itp_type_horse, 0, 1811,abundance(10)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["warhorse_steppe","Horse", [("horse_light_a",0)], itp_type_horse, 0, 1400,abundance(10)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
 ["warhorse_vaegir","Horse", [("horse_light_b",0)], itp_type_horse, 0, 1811,abundance(10)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion], ## CC
 ["charger","Horse", [("horse_light_c",0)], itp_type_horse, 0, 1811,abundance(40)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],

# AMMUNITION
## CC
# Apparently, rubik forgot to mark this block as modified although he added the missile_distance_trigger to them.
 ["arrows","Arrows", [("arrow_tyrk_a",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_a", ixmesh_carry)], itp_type_arrows|itp_merchandise|itp_default_ammo, itcf_carry_quiver_back, 72,weight(3)|abundance(160)|weapon_length(95)|thrust_damage(1,pierce)|max_ammo(30),imodbits_missile,missile_distance_trigger, [], [fac_kingdom_3, fac_kingdom_6]],
 ["arrows1","Arrows", [("arrow_tyrk_b",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_b", ixmesh_carry)], itp_type_arrows|itp_merchandise|itp_default_ammo, itcf_carry_quiver_back, 72,weight(3)|abundance(160)|weapon_length(95)|thrust_damage(1,pierce)|max_ammo(30),imodbits_missile,missile_distance_trigger, [], [fac_kingdom_3, fac_kingdom_6]],
 ["arrows2","Arrows", [("arrow_tyrk_c",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_c", ixmesh_carry)], itp_type_arrows|itp_merchandise|itp_default_ammo, itcf_carry_quiver_back, 72,weight(3)|abundance(160)|weapon_length(95)|thrust_damage(1,pierce)|max_ammo(30),imodbits_missile,missile_distance_trigger, [], [fac_kingdom_3, fac_kingdom_6]], 

 ["khergit_arrows","Arrows", [("arrow_tyrk_a",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_a", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back_right, 410,weight(3.5)|abundance(30)|weapon_length(95)|thrust_damage(3,pierce)|max_ammo(30),imodbits_missile,missile_distance_trigger],
 ["barbed_arrows","Arrows", [("arrow_tyrk_b",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_b", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back_right, 124,weight(3)|abundance(70)|weapon_length(95)|thrust_damage(2,pierce)|max_ammo(30),imodbits_missile,missile_distance_trigger],
 ["bodkin_arrows","Arrows", [("arrow_tyrk_c",0),("flying_missile",ixmesh_flying_ammo),("kolchan_tyrk_c", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back_right, 350,weight(3)|abundance(50)|weapon_length(91)|thrust_damage(3,pierce)|max_ammo(28),imodbits_missile,missile_distance_trigger],

 ["bolts","Bolts", [("crusade_bolt",0),("flying_missile",ixmesh_flying_ammo),("crusade_bolt_bag", ixmesh_carry),("crusade_bolt_bag", ixmesh_carry|imodbit_large_bag)], itp_type_bolts|itp_merchandise|itp_default_ammo|itp_can_penetrate_shield, itcf_carry_quiver_right_vertical, 64,weight(2.25)|abundance(90)|weapon_length(63)|thrust_damage(1,pierce)|max_ammo(29),imodbits_missile,missile_distance_trigger],
 ["bolts1","Bolts", [("crusade_bolt_heavy",0),("flying_missile",ixmesh_flying_ammo),("crusade_bolt_bag_heavy", ixmesh_carry),("crusade_bolt_bag_heavy", ixmesh_carry|imodbit_large_bag)], itp_type_bolts|itp_merchandise|itp_default_ammo|itp_can_penetrate_shield, itcf_carry_quiver_right_vertical, 64,weight(2.25)|abundance(90)|weapon_length(63)|thrust_damage(1,pierce)|max_ammo(29),imodbits_missile,missile_distance_trigger],
 ["bolts2","Bolts", [("crusade_bolt_heavy_pierce",0),("flying_missile",ixmesh_flying_ammo),("crusade_bolt_bag_heavy_pierce", ixmesh_carry),("crusade_bolt_bag_heavy_pierce", ixmesh_carry|imodbit_large_bag)], itp_type_bolts|itp_merchandise|itp_default_ammo|itp_can_penetrate_shield, itcf_carry_quiver_right_vertical, 64,weight(2.25)|abundance(90)|weapon_length(63)|thrust_damage(1,pierce)|max_ammo(29),imodbits_missile,missile_distance_trigger],

 ["steel_bolts","Bolts", [("crusade_bolt_heavy_pierce",0),("flying_missile",ixmesh_flying_ammo),("crusade_bolt_bag_heavy_pierce", ixmesh_carry)], itp_type_bolts|itp_can_penetrate_shield, itcf_carry_quiver_right_vertical, 210,weight(2.5)|abundance(20)|weapon_length(63)|thrust_damage(2,pierce)|max_ammo(29),imodbits_missile,missile_distance_trigger],
 ["cartridges","Cartridges", [("cartridge_a",0)], itp_type_bullets|itp_can_penetrate_shield|itp_default_ammo, 0, 41,weight(2.25)|abundance(90)|weapon_length(3)|thrust_damage(1,pierce)|max_ammo(50),imodbits_missile,missile_distance_trigger],
## CC


# DISGUISE
["pilgrim_disguise", "Pilgrim Disguise", [("beduin_armor_a",0)], 0| itp_type_body_armor |itp_covers_legs |itp_civilian ,0, 25 , weight(2)|abundance(100)|head_armor(0)|body_armor(19)|leg_armor(8)|difficulty(0) ,imodbits_cloth ],
["pilgrim_hood", "Pilgrim Hood", [("beduin_turban_b",0)], 0| itp_type_head_armor | itp_covers_beard | itp_attach_armature |itp_civilian  ,0, 35 , weight(1.25)|abundance(100)|head_armor(14)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],


# ARMOR
## Handwear
["leather_gloves","Leather Gloves", [("gloves_a_L",0)], itp_merchandise|itp_type_hand_armor,0, 90, weight(0.25)|abundance(50)|body_armor(2)|difficulty(0),imodbits_cloth],

["mail_mittens","Mail Mittens", [("gauntlets_crysader_L",0)], itp_type_hand_armor,0, 350, weight(0.5)|abundance(50)|body_armor(4)|difficulty(0),imodbits_armor],
["scale_gauntlets","Scale Gauntlets", [("gauntlets_arabs_b_L",0)], itp_type_hand_armor,0, 710, weight(0.75)|abundance(50)|body_armor(5)|difficulty(0),imodbits_armor],
["lamellar_gauntlets","Lamellar Gauntlets", [("gauntlets_arabs_a_L",0)], itp_type_hand_armor,0, 910, weight(0.75)|abundance(50)|body_armor(5)|difficulty(0),imodbits_armor],
["gauntlets","Gauntlets", [("gauntlets_arabs_b_L",0),("gauntlets_arabs_b_L",imodbit_reinforced)], itp_type_hand_armor,0, 1040, weight(1.0)|body_armor(6)|difficulty(0),imodbits_armor],

## Footwear
### Cloth
["wrapping_boots", "Wrapping Boots", [("saracin_light_boot_a",0)], itp_type_foot_armor |itp_civilian | itp_attach_armature ,0,
 3 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(3)|difficulty(0) ,imodbits_cloth ],
["woolen_hose", "Woolen Hose", [("saracin_light_boot_a",0)], itp_type_foot_armor |itp_civilian | itp_attach_armature ,0,
 6 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(4)|difficulty(0) ,imodbits_cloth ],
["blue_hose", "Blue Hose", [("saracin_light_boot_a",0)], itp_type_foot_armor |itp_civilian | itp_attach_armature ,0,
 11 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(5)|difficulty(0) ,imodbits_cloth ],
["ankle_boots", "Ankle Boots", [("boot_light_crusader_a",0)], itp_type_foot_armor |itp_civilian  | itp_attach_armature,0,
 75 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth ],
["sarranid_boots_a", "Muslim Shoes", [("saracin_light_boot_a",0)], itp_type_foot_armor |itp_civilian | itp_attach_armature ,0,
 30 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(8)|difficulty(0) ,imodbits_cloth ],

### Hide, Fur
["hunter_boots", "Hunter Boots", [("saracin_light_boot_a",0)], itp_type_foot_armor |itp_civilian | itp_attach_armature,0,
 19 , weight(1.25)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["hide_boots", "Hide Boots", [("saracin_light_boot_a",0)], itp_type_foot_armor |itp_civilian  | itp_attach_armature,0,
 34 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["nomad_boots", "Nomad Boots", [("saracin_light_boot_a",0)], itp_type_foot_armor  |itp_civilian | itp_attach_armature,0,
 90 , weight(1.25)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(14)|difficulty(0) ,imodbits_cloth ],

### Leather
["light_leather_boots",  "Light Leather Boots", [("saracin_light_boot_a",0)], itp_type_foot_armor | itp_attach_armature,0, 91 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(15)|difficulty(0) ,imodbits_cloth ],

["leather_boots", "Leather Boots", [("saracin_medium_boot_a",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0,
 174 , weight(1.25)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth ],

 ["sarranid_boots_b", "Leather Boots", [("saracin_light_boot_a",0)],  itp_type_foot_armor |itp_civilian | itp_attach_armature ,0,
 120 , weight(2)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth ],
["khergit_leather_boots", "Leather Boots", [("saracin_medium_boot_a",0)],  itp_type_foot_armor |itp_civilian | itp_attach_armature ,0,
 120 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(18)|difficulty(0) ,imodbits_cloth ],

### (Chain)Mail
["mail_chausses", "Mail Chausses", [("shoes_crusader",0)],  itp_type_foot_armor | itp_attach_armature  ,0,
 530 , weight(3)|abundance(30)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor ],
["sarranid_boots_d", "Sarranid Mail Boots", [("saracin_hard_boot_a",0)],  itp_type_foot_armor |itp_civilian | itp_attach_armature ,0,
 920 , weight(3)|abundance(30)|head_armor(0)|body_armor(0)|leg_armor(30)|difficulty(0) ,imodbits_armor ],
["mail_boots", "Mail Boots", [("shoes_crusader_knight",0)],  itp_type_foot_armor | itp_attach_armature  ,0,
 1250 , weight(3)|abundance(20)|head_armor(0)|body_armor(0)|leg_armor(31)|difficulty(8) ,imodbits_armor ],

### Splinted
["sarranid_boots_c", "Plated Boots", [("saracin_light_boot_a",0)],  itp_type_foot_armor |itp_civilian | itp_attach_armature ,0,
 280 , weight(3)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(20)|difficulty(0) ,imodbits_armor ],
["splinted_leather_greaves", "Splinted Leather Greaves", [("boot_average_crusader_a",0)],  itp_type_foot_armor | itp_attach_armature,0,
 310 , weight(2)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(21)|difficulty(0) ,imodbits_armor ],
["splinted_greaves", "Splinted Greaves", [("boot_average_crusader_b",0)],  itp_type_foot_armor | itp_attach_armature,0,
 853 , weight(2.75)|abundance(30)|head_armor(0)|body_armor(0)|leg_armor(28)|difficulty(7) ,imodbits_armor ],

### Plate
["iron_greaves", "Iron Greaves", [("shoes_crusader",0)], itp_type_foot_armor | itp_attach_armature,0,
 1770 , weight(3.5)|abundance(10)|head_armor(0)|body_armor(0)|leg_armor(33)|difficulty(9) ,imodbits_armor ],
["plate_boots", "Plate Boots", [("shoes_crusader_knight",0)], itp_type_foot_armor | itp_attach_armature,0,
 1770 , weight(3.5)|abundance(10)|head_armor(0)|body_armor(0)|leg_armor(33)|difficulty(9) ,imodbits_armor ],
["black_greaves", "Black Greaves", [("shoes_crusader_knight",0)], itp_type_foot_armor  | itp_attach_armature,0,
 2361 , weight(3.5)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(30)|difficulty(0) ,imodbits_armor ],


## Bodywear
### Courtly
["courtly_outfit", "Rich Outfit", [("noble2",0)], itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(100)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["nobleman_outfit", "Rich Outfit", [("noble4",0)], itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(100)|head_armor(0)|body_armor(15)|leg_armor(12)|difficulty(0) ,imodbits_cloth ],
["rich_outfit", "Rich Outfit", [("noble6",0)], itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(100)|head_armor(0)|body_armor(16)|leg_armor(4)|difficulty(0) ,imodbits_cloth ],
["lady_dress_ruby", "Lady Dress", [("lady_dress_r",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["lady_dress_green", "Lady Dress", [("lady_dress_r",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["lady_dress_blue", "Lady Dress", [("lady_dress_r",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["red_dress", "Muslim Lady Dress", [("brown_dress",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["brown_dress", "Muslim Lady Dress", [("brown_dress",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["green_dress", "Muslim Lady Dress", [("brown_dress",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["khergit_lady_dress", "Muslim Lady Dress", [("brown_dress",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["khergit_lady_dress_b", "Muslim Leather Lady Dress", [("brown_dress",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["sarranid_lady_dress", "Muslim Lady Dress", [("brown_dress",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["sarranid_lady_dress_b", "Muslim Lady Dress", [("brown_dress",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["sarranid_common_dress", "Muslim Dress", [("aldeana1",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["sarranid_common_dress_b", "Muslim Dress", [("aldeana1",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],


### Civilian
["shirt", "Tunic", [("civil1",0)],  itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 3 , weight(1)|abundance(100)|head_armor(0)|body_armor(5)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["dress", "Dress", [("aldeana1",0)],  itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 6 , weight(1)|abundance(100)|head_armor(0)|body_armor(6)|leg_armor(2)|difficulty(0) ,imodbits_cloth ],
["blue_dress", "Dress", [("aldeana1",0)],  itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 6 , weight(1)|abundance(100)|head_armor(0)|body_armor(6)|leg_armor(2)|difficulty(0) ,imodbits_cloth ],
["peasant_dress", "Dress", [("aldeana1",0)],  itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 6 , weight(1)|abundance(100)|head_armor(0)|body_armor(6)|leg_armor(2)|difficulty(0) ,imodbits_cloth ],
["tunic_with_green_cape", "Tunic", [("noble6",0)],  itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 6 , weight(1)|abundance(100)|head_armor(0)|body_armor(6)|leg_armor(2)|difficulty(0) ,imodbits_cloth ],
# ["linen_tunic", "Linen Tunic", [("shirt_a",0)], itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 6 , weight(1)|abundance(100)|head_armor(0)|body_armor(6)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["short_tunic", "Tunic", [("noble4",0)], itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 10 , weight(1)|abundance(100)|head_armor(0)|body_armor(7)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["red_shirt", "Tunic", [("noble2",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 10 , weight(1)|abundance(100)|head_armor(0)|body_armor(7)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["red_tunic", "Red Tunic", [("sargento_perpunt2",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 10 , weight(1)|abundance(100)|head_armor(0)|body_armor(7)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["green_tunic", "Green Tunic", [("sargento_perpunt5",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 10 , weight(1)|abundance(100)|head_armor(0)|body_armor(7)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["blue_tunic", "Blue Tunic", [("sargento_perpunt1",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 10 , weight(1)|abundance(100)|head_armor(0)|body_armor(7)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["woolen_dress", "Dress", [("aldeana1",0)],  itp_type_body_armor|itp_civilian  |itp_covers_legs ,0, 10 , weight(1.75)|abundance(100)|head_armor(0)|body_armor(8)|leg_armor(2)|difficulty(0) ,imodbits_cloth ],
["robe", "Robe", [("robe",0)],  itp_type_body_armor  |itp_covers_legs |itp_civilian,0, 31 , weight(1.5)|abundance(100)|head_armor(0)|body_armor(8)|leg_armor(6)|difficulty(0) ,imodbits_cloth ],
["sarranid_dress_a", "Dress", [("aldeana1",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["sarranid_dress_b", "Dress", [("aldeana1",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["sarranid_cloth_robe", "Tunic", [("beduin_armor_a",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["sarranid_cloth_robe_b", "Tunic", [("beduin_armor_b",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["coarse_tunic", "Tunic", [("beduin_armor_c",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 47 , weight(2)|abundance(100)|head_armor(0)|body_armor(11)|leg_armor(6)|difficulty(0) ,imodbits_cloth ],
["leather_apron", "Tunic", [("turk_bandit_d",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 61 , weight(3)|abundance(100)|head_armor(0)|body_armor(12)|leg_armor(7)|difficulty(0) ,imodbits_cloth ],

### Cloth
["tabard", "Tunic", [("noble2",0)],  itp_type_body_armor  |itp_covers_legs |itp_civilian,0, 107 , weight(3)|abundance(100)|head_armor(0)|body_armor(14)|leg_armor(6)|difficulty(0) ,imodbits_cloth ],
# ["skirmisher_armor", "Skirmisher Armor", [("skirmisher_armor",0)], itp_type_body_armor  |itp_covers_legs ,0, 74 , weight(3)|abundance(100)|head_armor(0)|body_armor(15)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["nomad_robe", "Tunic", [("arab_bandit_d",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs |itp_civilian,0, 610 , weight(15)|abundance(100)|head_armor(0)|body_armor(32)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],

### Padded Cloth
["gambeson", "Tunic", [("dethertir_armor_h",0)],  itp_type_body_armor|itp_covers_legs|itp_civilian,0, 260 , weight(5)|abundance(100)|head_armor(0)|body_armor(20)|leg_armor(5)|difficulty(0) ,imodbits_cloth ],
["blue_gambeson", "Blue Tunic", [("sargento_perpunt1",0)],  itp_type_body_armor|itp_covers_legs|itp_civilian,0, 270 , weight(5)|abundance(100)|head_armor(0)|body_armor(21)|leg_armor(5)|difficulty(0) ,imodbits_cloth ],
["red_gambeson", "Red Tunic", [("sargento_perpunt2",0)],  itp_type_body_armor|itp_covers_legs|itp_civilian,0, 275 , weight(5)|abundance(100)|head_armor(0)|body_armor(21)|leg_armor(5)|difficulty(0) ,imodbits_cloth ],
["padded_cloth", "Tunic", [("dethertir_armor_h",0)],  itp_type_body_armor  |itp_covers_legs ,0, 297 , weight(11)|abundance(100)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth ],
["aketon_green", "Tunic", [("dethertir_armor_h",0)],  itp_type_body_armor  |itp_covers_legs ,0, 297 , weight(11)|abundance(100)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth ],
["archers_vest", "Tunic", [("dethertir_armor_h",0)],  itp_type_body_armor  |itp_covers_legs ,0, 260 , weight(6)|abundance(100)|head_armor(0)|body_armor(23)|leg_armor(12)|difficulty(0) ,imodbits_cloth ],

### Fur, Hide
["pelt_coat", "Tunic", [("turk_bandit_a",0)],  itp_type_body_armor  |itp_covers_legs ,0, 14, weight(2)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(1)|difficulty(0) ,imodbits_cloth ],
["rawhide_coat", "Tunic", [("turk_bandit_a",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 12 , weight(5)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["fur_coat", "Tunic", [("turk_bandit_c",0)], itp_type_body_armor  |itp_covers_legs |itp_civilian,0, 117 , weight(6)|abundance(100)|head_armor(0)|body_armor(13)|leg_armor(6)|difficulty(0) ,imodbits_armor ],
["nomad_vest", "Tunic", [("turk_bandit_c",0)],  itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 360 , weight(7)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(8)|difficulty(0) ,imodbits_cloth ],
["nomad_armor", "Tunic", [("turk_bandit_b",0)],  itp_type_body_armor |itp_covers_legs   ,0, 25 , weight(2)|abundance(100)|head_armor(0)|body_armor(24)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["khergit_armor", "Tunic", [("turk_bandit_b",0)],  itp_type_body_armor | itp_covers_legs ,0, 38 , weight(2)|abundance(100)|head_armor(0)|body_armor(24)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],

### Leather
# ["leather_vest", "Leather Vest", [("leather_vest_a",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 146 , weight(4)|abundance(100)|head_armor(0)|body_armor(15)|leg_armor(7)|difficulty(0) ,imodbits_cloth ],
["leather_armor", "Tunic", [("dethertir_armor_f",0)],  itp_type_body_armor |itp_covers_legs  ,0, 65 , weight(7)|abundance(100)|head_armor(0)|body_armor(18)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["leather_jacket", "Tunic", [("dethertir_armor_f",0)],  itp_type_body_armor | itp_covers_legs  |itp_civilian ,0, 50 , weight(3)|abundance(100)|head_armor(0)|body_armor(20)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["leather_jerkin", "Tunic", [("dethertir_armor_b",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 321 , weight(6)|abundance(50)|head_armor(0)|body_armor(23)|leg_armor(6)|difficulty(0) ,imodbits_cloth ],
["ragged_outfit", "Tunic", [("dethertir_armor_b",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 390 , weight(7)|abundance(50)|head_armor(0)|body_armor(23)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["light_leather", "Tunic", [("dethertir_armor_d",0)], itp_type_body_armor|itp_covers_legs   ,0, 352 , weight(5)|abundance(50)|head_armor(0)|body_armor(26)|leg_armor(7)|difficulty(0) ,imodbits_armor ],
["padded_leather", "Tunic", [("dethertir_armor_d",0)],  itp_type_body_armor  |itp_covers_legs|itp_civilian,0, 454 , weight(12)|abundance(50)|head_armor(0)|body_armor(27)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["tribal_warrior_outfit", "Tunic", [("arab_bandit_d",0)],  itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 520 , weight(14)|abundance(40)|head_armor(0)|body_armor(30)|leg_armor(10)|difficulty(0) ,imodbits_cloth ],
["sarranid_leather_armor", "Tunic", [("arab_bandit_c",0)],  itp_type_body_armor  |itp_covers_legs ,0, 650 , weight(9)|abundance(40)|head_armor(0)|body_armor(32)|leg_armor(12)|difficulty(0) ,imodbits_armor ],

### (Chain)Mail
["studded_leather_coat", "Armor", [("dethertir_armor_c",0)],  itp_type_body_armor  |itp_covers_legs ,0, 690 , weight(14)|abundance(40)|head_armor(0)|body_armor(36)|leg_armor(10)|difficulty(7) ,imodbits_armor ],
["sarranid_cavalry_robe", "Armor", [("arab_bandit_b",0)],  itp_type_body_armor  |itp_covers_legs |itp_civilian,0, 990 , weight(15)|abundance(30)|head_armor(0)|body_armor(36)|leg_armor(8)|difficulty(0) ,imodbits_armor ],
["mail_shirt", "Armor", [("dethertir_armor_c",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1040 , weight(19)|abundance(30)|head_armor(0)|body_armor(37)|leg_armor(12)|difficulty(7) ,imodbits_armor ],
["byrnie", "Armor", [("dethertir_armor_g",0)],  itp_type_body_armor  |itp_covers_legs ,0, 795 , weight(17)|abundance(40)|head_armor(0)|body_armor(39)|leg_armor(6)|difficulty(7) ,imodbits_armor ],
["mail_with_tunic_red", "Red Armor", [("sargento_perpunt2",0)], itp_type_body_armor  |itp_covers_legs ,0, 650 , weight(16)|abundance(40)|head_armor(0)|body_armor(39)|leg_armor(8), imodbits_armor ],
["mail_with_tunic_green", "Green Armor", [("sargento_perpunt5",0)], itp_type_body_armor  |itp_covers_legs ,0, 650 , weight(16)|abundance(40)|head_armor(0)|body_armor(39)|leg_armor(8), imodbits_armor ],
["sarranid_mail_shirt", "Armor", [("arab_bandit_b",0)],  itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 1400 , weight(19)|abundance(20)|head_armor(0)|body_armor(40)|leg_armor(14)|difficulty(7) ,imodbits_armor ],
["mail_hauberk", "Armor", [("dethertir_armor_g",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1320 , weight(19)|abundance(20)|head_armor(0)|body_armor(40)|leg_armor(12)|difficulty(7) ,imodbits_armor ],
["haubergeon", "Armor", [("dethertir_armor_e",0)],  itp_type_body_armor  |itp_covers_legs ,0, 863 , weight(18)|abundance(40)|head_armor(0)|body_armor(41)|leg_armor(6)|difficulty(6) ,imodbits_armor ],
["mail_with_surcoat", "Armor", [("dethertir_armor_e",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1544 , weight(22)|abundance(10)|head_armor(0)|body_armor(42)|leg_armor(14)|difficulty(7) ,imodbits_armor ],
["surcoat_over_mail", "Armor", [("dethertir_armor_e",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1720 , weight(22)|abundance(10)|head_armor(0)|body_armor(43)|leg_armor(14)|difficulty(7) ,imodbits_armor ],
["banded_armor", "Armor", [("dethertir_armor_e",0)],  itp_type_body_armor  |itp_covers_legs ,0, 2710 , weight(23)|abundance(10)|head_armor(0)|body_armor(49)|leg_armor(14)|difficulty(8) ,imodbits_armor ],
["heraldic_mail_with_surcoat", "Heraldic Mail with Surcoat", [("heraldic_armor_new_a",0)],  itp_type_body_armor  |itp_covers_legs ,0, 3454 , weight(22)|abundance(10)|head_armor(0)|body_armor(49)|leg_armor(17)|difficulty(7) ,imodbits_armor,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heraldic_armor_a", ":agent_no", ":troop_no")])]],
["heraldic_mail_with_tunic", "Heraldic Mail", [("heraldic_armor_new_b",0)],  itp_type_body_armor  |itp_covers_legs ,0, 3520 , weight(22)|abundance(10)|head_armor(0)|body_armor(50)|leg_armor(16)|difficulty(7) ,imodbits_armor,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heraldic_armor_b", ":agent_no", ":troop_no")])]],
["heraldic_mail_with_tunic_b", "Heraldic Mail", [("heraldic_armor_new_c",0)],  itp_type_body_armor  |itp_covers_legs ,0, 3610 , weight(22)|abundance(10)|head_armor(0)|body_armor(50)|leg_armor(16)|difficulty(7) ,imodbits_armor,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heraldic_armor_c", ":agent_no", ":troop_no")])]],
["heraldic_mail_with_tabard", "Heraldic Mail with Tabard", [("heraldic_armor_new_d",0)],  itp_type_body_armor  |itp_covers_legs ,0, 3654 , weight(21)|abundance(10)|head_armor(0)|body_armor(51)|leg_armor(15)|difficulty(7) ,imodbits_armor,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heraldic_armor_d", ":agent_no", ":troop_no")])]],

### Scale, Lamellar
["steppe_armor", "Armor", [("armor_medium_tyrk_b",0)],  itp_type_body_armor  |itp_covers_legs ,0, 195 , weight(5)|abundance(100)|head_armor(0)|body_armor(16)|leg_armor(8)|difficulty(0) ,imodbits_cloth ],
["arabian_armor_b", "Armor", [("armor_archer_saracin_2",0)],  itp_type_body_armor  |itp_covers_legs ,0, 1200 , weight(19)|abundance(20)|head_armor(0)|body_armor(38)|leg_armor(8)|difficulty(0) ,imodbits_armor],
["lamellar_vest", "Armor", [("armor_medium_tyrk_c",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 970 , weight(18)|abundance(40)|head_armor(0)|body_armor(40)|leg_armor(8)|difficulty(7) ,imodbits_cloth ],
["lamellar_vest_khergit", "Armor", [("armor_medium_tyrk_d",0)],  itp_type_body_armor |itp_civilian |itp_covers_legs ,0, 970 , weight(18)|abundance(40)|head_armor(0)|body_armor(40)|leg_armor(8)|difficulty(7) ,imodbits_cloth ],
["lamellar_armor", "Armor", [("heavy_armor_arabs_a",0)],  itp_type_body_armor  |itp_covers_legs ,0, 2410 , weight(25)|abundance(10)|head_armor(0)|body_armor(48)|leg_armor(13)|difficulty(0) ,imodbits_armor ],
["scale_armor", "Armor", [("Ghulam_heavy_cavalryman_3",0)],  itp_type_body_armor  |itp_covers_legs ,0, 2558 , weight(25)|abundance(10)|head_armor(0)|body_armor(52)|leg_armor(13)|difficulty(8) ,imodbits_armor ],
["khergit_elite_armor", "Armor", [("Ghulam_heavy_cavalryman_2",0)],  itp_type_body_armor  |itp_covers_legs ,0, 3828 , weight(25)|abundance(10)|head_armor(0)|body_armor(52)|leg_armor(16)|difficulty(8) ,imodbits_armor ],
["vaegir_elite_armor", "Armor", [("Ghulam_heavy_cavalryman_1",0)],  itp_type_body_armor  |itp_covers_legs ,0, 3828 , weight(25)|abundance(10)|head_armor(0)|body_armor(52)|leg_armor(16)|difficulty(8) ,imodbits_armor ],
["sarranid_elite_armor", "Armor", [("Ghulam_heavy_cavalryman_2",0)],  itp_type_body_armor  |itp_covers_legs |itp_civilian ,0, 3828 , weight(25)|abundance(10)|head_armor(0)|body_armor(52)|leg_armor(16)|difficulty(8) ,imodbits_armor ],

### Jazeran
["mamluke_mail", "Armor", [("tyrk_armor_heavi_a",0)], itp_type_body_armor  |itp_covers_legs ,0, 3828 , weight(25)|abundance(10)|head_armor(0)|body_armor(52)|leg_armor(16)|difficulty(8) ,imodbits_armor ],

### Mixed
["brigandine_red", "Armor", [("dethertir_armor_g",0)],  itp_type_body_armor|itp_covers_legs,0, 1830 , weight(19)|abundance(10)|head_armor(0)|body_armor(46)|leg_armor(12)|difficulty(0) ,imodbits_armor ],
["cuir_bouilli", "Armor", [("dethertir_armor_c",0)],  itp_type_body_armor  |itp_covers_legs ,0, 3100 , weight(24)|abundance(10)|head_armor(0)|body_armor(50)|leg_armor(15)|difficulty(8) ,imodbits_armor ],

### Plate
["coat_of_plates", "Armor", [("dethertir_armor_e",0)], itp_type_body_armor  |itp_covers_legs ,0, 3828 , weight(25)|abundance(10)|head_armor(0)|body_armor(52)|leg_armor(16)|difficulty(8) ,imodbits_armor ],
["coat_of_plates_red", "Armor", [("dethertir_armor_e",0)], itp_type_body_armor  |itp_covers_legs ,0, 3828 , weight(25)|abundance(10)|head_armor(0)|body_armor(52)|leg_armor(16)|difficulty(8) ,imodbits_armor ],
# ["plate_armor", "Plate Armor", [("full_plate_armor",0)], itp_type_body_armor  |itp_covers_legs ,0, 6553 , weight(27)|abundance(100)|head_armor(0)|body_armor(55)|leg_armor(17)|difficulty(9) ,imodbits_armor ],
["black_armor", "Armor", [("dethertir_armor_e",0)], itp_type_body_armor  |itp_covers_legs ,0, 9496 , weight(25)|abundance(0)|head_armor(0)|body_armor(52)|leg_armor(16)|difficulty(10) ,imodbits_armor ],

### Quest-specific - perhaps can be used for prisoners,
["burlap_tunic", "Tunic", [("civil1",0)], itp_type_body_armor  |itp_covers_legs ,0, 5 , weight(1)|abundance(100)|head_armor(0)|body_armor(3)|leg_armor(1)|difficulty(0) ,imodbits_armor ],


## Headwear
### Civilian
["straw_hat", "Straw Hat", [("straw_hat_new",0)],itp_type_head_armor|itp_civilian,0,9, weight(1)|abundance(100)|head_armor(2)|body_armor(0)|leg_armor(0)|difficulty(0),imodbits_cloth],
["head_wrappings","Head Wrapping",[("head_wrapping",0)],itp_type_head_armor|itp_fit_to_head,0,16, weight(0.25)|head_armor(3),imodbit_tattered | imodbit_ragged | imodbit_sturdy | imodbit_thick],
["headcloth", "Headcloth", [("headcloth_a_new",0)],  itp_type_head_armor  |itp_civilian ,0, 1 , weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["sarranid_felt_hat", "Felt Hat", [("sar_helmet3",0)],  itp_type_head_armor   ,0, 16 , weight(2)|abundance(100)|head_armor(5)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_cloth ],
["woolen_cap", "Woolen Cap", [("woolen_cap_new",0)],  itp_type_head_armor  |itp_civilian ,0, 2 , weight(1)|abundance(100)|head_armor(6)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["fur_hat", "Fur Hat", [("fur_hat_a_new",0)],  itp_type_head_armor |itp_civilian  ,0, 4 , weight(0.5)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["felt_hat", "Felt Hat", [("felt_hat_a_new",0)],  itp_type_head_armor |itp_civilian,0, 4 , weight(1)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["felt_hat_b", "Felt Hat", [("felt_hat_b_new",0)],  itp_type_head_armor |itp_civilian,0, 4 , weight(1)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["turban", "Turban", [("beduin_turban_a",0)],  itp_type_head_armor | itp_attach_armature   ,0, 28 , weight(1)|abundance(100)|head_armor(11)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],

### Hoods
["woolen_hood", "Turban", [("beduin_turban_a",0)],  itp_type_head_armor |itp_civilian | itp_fit_to_head | itp_attach_armature ,0, 4 , weight(1)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["common_hood", "Turban", [("beduin_turban_a",0)],itp_type_head_armor|itp_civilian | itp_fit_to_head | itp_attach_armature,0,9, weight(1)|abundance(100)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0),imodbits_cloth],
["female_hood", "Head Cloth", [("sayazn_new_veil_black",0)],  itp_type_head_armor |itp_civilian |itp_attach_armature ,0, 9 , weight(1)|abundance(100)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["hood_b", "Turban", [("beduin_turban_a",0)],itp_type_head_armor|itp_civilian | itp_fit_to_head | itp_attach_armature,0,9, weight(1)|abundance(100)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0),imodbits_cloth],
["hood_c", "Turban", [("beduin_turban_a",0)],itp_type_head_armor|itp_civilian | itp_fit_to_head | itp_attach_armature,0,9, weight(1)|abundance(100)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0),imodbits_cloth],
["hood_d", "Turban", [("beduin_turban_a",0)],itp_type_head_armor|itp_civilian | itp_fit_to_head | itp_attach_armature,0,9, weight(1)|abundance(100)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0),imodbits_cloth],
["black_hood", "Turban", [("beduin_turban_a",0)], itp_type_head_armor | itp_fit_to_head | itp_attach_armature  ,0, 193 , weight(2)|abundance(100)|head_armor(18)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],

### Courtly
["turret_hat_ruby", "Turret Hat", [("turret_hat_r",0)], itp_type_head_armor  |itp_civilian|itp_fit_to_head ,0, 70 , weight(0.5)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["turret_hat_blue", "Turret Hat", [("turret_hat_r",0)], itp_type_head_armor  |itp_civilian|itp_fit_to_head ,0, 80 , weight(0.5)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["turret_hat_green", "Turret Hat", [("turret_hat_r",0)],itp_type_head_armor|itp_civilian|itp_fit_to_head,0,70, weight(0.5)|abundance(100)|head_armor(6)|body_armor(0)|leg_armor(0)|difficulty(0),imodbits_cloth],
["court_hat", "Turret Hat", [("turret_hat_r",0)], itp_type_head_armor  |itp_civilian|itp_fit_to_head ,0, 80 , weight(0.5)|abundance(100)|head_armor(8)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["wimple_a", "Turret Hat", [("turret_hat_r",0)],itp_type_head_armor|itp_civilian|itp_fit_to_head,0,10, weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0),imodbits_cloth],
["wimple_with_veil", "Head Cloth", [("sayazn_new_veil_black",0)],itp_type_head_armor  |itp_civilian |itp_attach_armature,0, 1 , weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["khergit_lady_hat", "Head Cloth", [("sayazn_new_veil_black",0)],  itp_type_head_armor  |itp_civilian |itp_attach_armature,0, 1 , weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["khergit_lady_hat_b", "Head Cloth", [("sayazn_new_veil_black",0)], itp_type_head_armor  |itp_civilian |itp_attach_armature,0, 1 , weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["sarranid_head_cloth", "Head Cloth", [("sayazn_new_veil_black",0)],  itp_type_head_armor  |itp_civilian |itp_attach_armature,0, 1 , weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["sarranid_head_cloth_b", "Head Cloth", [("sayazn_new_veil_black",0)],  itp_type_head_armor  |itp_civilian |itp_attach_armature,0, 1 , weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["sarranid_felt_head_cloth", "Head Cloth", [("sayazn_new_veil_black",0)],  itp_type_head_armor  |itp_civilian |itp_attach_armature,0, 1 , weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["sarranid_felt_head_cloth_b", "Head Cloth", [("sayazn_new_veil_black",0)],  itp_type_head_armor  |itp_civilian |itp_attach_armature,0, 1 , weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],

### Cloth
["padded_coif", "Coif", [("koif_monie_b",0)],  itp_type_head_armor |itp_fit_to_head  ,0, 6 , weight(1)|abundance(50)|head_armor(11)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],

### Fur, Hide
["nomad_cap", "Turban", [("beduin_turban_a",0)],  itp_type_head_armor |itp_civilian | itp_fit_to_head | itp_attach_armature   ,0, 6 , weight(0.75)|abundance(100)|head_armor(10)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["nomad_cap_b", "Turban", [("beduin_turban_a",0)],  itp_type_head_armor |itp_civilian | itp_fit_to_head | itp_attach_armature   ,0, 6 , weight(0.75)|abundance(100)|head_armor(13)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["steppe_cap", "Turban", [("beduin_turban_a",0)],  itp_type_head_armor  |itp_civilian | itp_fit_to_head | itp_attach_armature  ,0, 14 , weight(1)|abundance(100)|head_armor(16)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],

### Leather
["leather_steppe_cap_a", "Turban", [("beduin_turban_a",0)], itp_type_head_armor | itp_fit_to_head | itp_attach_armature    ,0,24 , weight(1)|abundance(100)|head_armor(12)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["leather_steppe_cap_b", "Turban ", [("beduin_turban_a",0)], itp_type_head_armor | itp_fit_to_head | itp_attach_armature    ,0,36 , weight(1)|abundance(100)|head_armor(14)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["leather_steppe_cap_c", "Turban", [("beduin_turban_a",0)], itp_type_head_armor | itp_fit_to_head | itp_attach_armature    ,0, 51 , weight(1)|abundance(100)|head_armor(16)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["leather_cap", "Turban", [("beduin_turban_a",0)],  itp_type_head_armor|itp_civilian | itp_fit_to_head | itp_attach_armature  ,0, 8, weight(1)|abundance(100)|head_armor(18)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["leather_warrior_cap", "Turban", [("beduin_turban_a",0)],  itp_type_head_armor  |itp_civilian | itp_fit_to_head | itp_attach_armature  ,0, 14 , weight(1)|abundance(100)|head_armor(18)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],

### Helmets
["arming_cap", "Coif", [("koif_monie_b",0)],  itp_type_head_armor  |itp_civilian ,0, 5 , weight(1)|abundance(100)|head_armor(7)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["nordic_archer_helmet", "Helmet", [("light_capelina_crusader_b",0)],  itp_type_head_armor    ,0, 40 , weight(1.25)|abundance(100)|head_armor(14)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["desert_turban", "Turban", [("beduin_turban_a",0)],  itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0, 38 , weight(1.50)|abundance(100)|head_armor(14)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_cloth ],
["vaegir_fur_cap", "Helmet", [("light_crusader_helm_a",0)],  itp_type_head_armor   ,0, 50 , weight(1)|abundance(100)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["sarranid_warrior_cap", "Helmet", [("helm_saracin_2",0)],  itp_type_head_armor | itp_covers_beard  ,0, 90 , weight(2)|abundance(100)|head_armor(19)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["nordic_veteran_archer_helmet", "Helmet", [("light_capelina_crusader_a",0)],  itp_type_head_armor,0, 70 , weight(1.5)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["skullcap", "Helmet", [("light_crusader_helm_b",0)],  itp_type_head_armor   ,0, 60 , weight(1.0)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor ],
["vaegir_fur_helmet", "Helmet", [("light_crusader_helm_b",0)],  itp_type_head_armor   ,0, 110 , weight(2)|abundance(100)|head_armor(21)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["mail_coif", "Mail Coif", [("crusader_koif_a",0)],  itp_type_head_armor   ,0, 71 , weight(1.25)|abundance(100)|head_armor(22)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["footman_helmet", "Helmet", [("marching_helmet_crusader_a",0)], itp_type_head_armor   ,0, 95 , weight(1.5)|abundance(100)|head_armor(24)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor ],
["sarranid_horseman_helmet", "Helmet", [("gulam_helm_b",0)],  itp_type_head_armor | itp_covers_beard | itp_attach_armature  ,0, 180 , weight(2.75)|abundance(100)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["nasal_helmet", "Helmet", [("crusader_helm_medium_a",0)],  itp_type_head_armor   ,0, 121 , weight(1.25)|abundance(100)|head_armor(26)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["norman_helmet", "Helmet", [("crusader_helm_medium_c",0)],  itp_type_head_armor|itp_fit_to_head ,0, 147 , weight(1.25)|abundance(100)|head_armor(28)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["nordic_footman_helmet", "Helmet", [("capelina_crusader_b",0)],  itp_type_head_armor |itp_fit_to_head ,0, 150 , weight(1.75)|abundance(100)|head_armor(30)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["segmented_helmet", "Helmet", [("capelina_crusader_a",0)],  itp_type_head_armor   ,0, 174 , weight(1.25)|abundance(100)|head_armor(31)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["khergit_war_helmet", "Helmet", [("helm_tyrk_heavi_b",0)], itp_type_head_armor    ,0, 200 , weight(2)|abundance(100)|head_armor(31)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["vaegir_spiked_helmet", "Helmet", [("fracia_helmet_1",0)],  itp_type_head_armor   ,0, 230 , weight(2.50)|abundance(100)|head_armor(32)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["helmet_with_neckguard", "Helmet", [("fracia_helmet_2",0)],  itp_type_head_armor, 0, 190, weight(1.5)|abundance(100)|head_armor(32)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["flat_topped_helmet", "Helmet", [("light_crusader_helm_d",0)],  itp_type_head_armor, 0, 203, weight(1.75)|abundance(100)|head_armor(33)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["nordic_fighter_helmet", "Helmet", [("crusader_hard_helm_a",0)],  itp_type_head_armor|itp_fit_to_head ,0, 240 , weight(2)|abundance(100)|head_armor(34)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["kettle_hat", "Helmet", [("capelina_crusader_b",0)],  itp_type_head_armor, 0, 240, weight(1.75)|abundance(100)|head_armor(35)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["sarranid_helmet1", "Helmet", [("helm_saracin_j",0)],  itp_type_head_armor   ,0, 290 , weight(2.50)|abundance(100)|head_armor(35)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["khergit_cavalry_helmet", "Helmet", [("helm_tyrk_heavi_c",0)], itp_type_head_armor    ,0, 333 , weight(2)|abundance(100)|head_armor(36)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["spiked_helmet", "Helmet", [("crusader_hard_helm_b",0)],  itp_type_head_armor   ,0, 278 , weight(2)|abundance(100)|head_armor(38)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["vaegir_lamellar_helmet", "Helmet", [("crusader_hard_helm_f",0)],  itp_type_head_armor   ,0, 360 , weight(2.75)|abundance(70)|head_armor(38)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["nordic_helmet", "Helmet", [("crusader_hard_helm_c",0)],  itp_type_head_armor   ,0, 340 , weight(2)|abundance(70)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["nordic_huscarl_helmet", "Helmet", [("crusader_helm_3",0)],  itp_type_head_armor   ,0, 390 , weight(2)|abundance(700)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["khergit_guard_helmet", "Helmet", [("gulam_helm_a",0)], itp_type_head_armor    ,0, 433 , weight(2)|abundance(50)|head_armor(40)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["sarranid_mail_coif", "Helmet", [("saracin_turban_b",0)],  itp_type_head_armor ,0, 430 , weight(3)|abundance(50)|head_armor(41)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["vaegir_noble_helmet", "Helmet", [("crusader_helm_5",0)],  itp_type_head_armor   ,0, 710, weight(2.75)|abundance(50)|head_armor(45)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["guard_helmet", "Helmet", [("crusader_helm_1",0)],  itp_type_head_armor   ,0, 555 , weight(2.5)|abundance(50)|head_armor(47)|body_armor(0)|leg_armor(0)|difficulty(9) ,imodbits_armor ],
["vaegir_war_helmet", "Helmet", [("crusader_helm_4",0)],  itp_type_head_armor   ,0, 820 , weight(3)|abundance(40)|head_armor(47)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["sarranid_veiled_helmet", "Helmet", [("gulam_helm_f",0)],  itp_type_head_armor|itp_covers_beard | itp_attach_armature ,0, 1240 , weight(2.75)|abundance(10)|head_armor(53)|body_armor(0)|leg_armor(0)|difficulty(10) ,imodbits_armor ],
["nordic_warlord_helmet", "Helmet", [("crusader_hard_helm_d",0)],  itp_type_head_armor ,0, 880 , weight(2.25)|abundance(40)|head_armor(48)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["vaegir_mask", "Helmet", [("crusader_helm_2",0)],  itp_type_head_armor |itp_covers_beard ,0, 950 , weight(3.50)|abundance(30)|head_armor(52)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],

### Bascinet
# ["bascinet", "Bascinet", [("bascinet_avt_new",0)], itp_type_head_armor   ,0, 479 , weight(2.25)|abundance(100)|head_armor(45)|body_armor(0)|leg_armor(0)|difficulty(8) ,imodbits_armor ],
# ["bascinet_2", "Bascinet with Aventail", [("bascinet_new_a",0)], itp_type_head_armor   ,0, 479 , weight(2.25)|abundance(100)|head_armor(45)|body_armor(0)|leg_armor(0)|difficulty(8) ,imodbits_armor ],
# ["bascinet_3", "Bascinet with Nose Guard", [("bascinet_new_b",0)], itp_type_head_armor   ,0, 479 , weight(2.25)|abundance(100)|head_armor(45)|body_armor(0)|leg_armor(0)|difficulty(8) ,imodbits_armor ],

### Barbuta
["black_helmet", "Helmet", [("crusader_hard_helm_d",0)], itp_type_head_armor,0, 1500 , weight(2.75)|abundance(0)|head_armor(53)|body_armor(0)|leg_armor(0)|difficulty(8) ,imodbits_armor ],

### Great Helmet
["full_helm", "Helmet", [("crusader_hard_helm_c",0)],  itp_type_head_armor |itp_covers_head ,0, 1240 , weight(2.5)|abundance(10)|head_armor(53)|body_armor(0)|leg_armor(0)|difficulty(10) ,imodbits_armor ],
["great_helmet", "Helmet", [("crusader_hard_helm_c",0)],  itp_type_head_armor|itp_covers_head,0, 1240 , weight(2.75)|abundance(10)|head_armor(53)|body_armor(0)|leg_armor(0)|difficulty(10) ,imodbits_armor ],
["winged_great_helmet", "Helmet", [("crusader_hard_helm_c",0)], itp_covers_head|itp_fit_to_head,0, 1240 , weight(2.75)|abundance(10)|head_armor(53)|body_armor(0)|leg_armor(0)|difficulty(10) ,imodbits_armor ],

# WEAPONS
## Clubs
["wooden_stick",         "Wooden Stick", [("wooden_stick",0)], itp_type_one_handed_wpn| itp_primary|itp_wooden_parry|itp_wooden_attack, itc_scimitar, 4, weight(2.5)|difficulty(0)|spd_rtng(99) | weapon_length(63)|swing_damage(13 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],
["cudgel",         "Cudgel", [("club",0)], itp_type_one_handed_wpn| itp_primary|itp_wooden_parry|itp_wooden_attack, itc_scimitar, 4, weight(2.5)|difficulty(0)|spd_rtng(99) | weapon_length(70)|swing_damage(13 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],
["club",         "Club", [("club",0)], itp_type_one_handed_wpn| itp_can_knock_down|itp_primary|itp_wooden_parry|itp_wooden_attack, itc_scimitar, 11, weight(2.5)|difficulty(0)|spd_rtng(98) | weapon_length(70)|swing_damage(20 , blunt) | thrust_damage(0 ,  pierce),imodbits_none ],

["spiked_club",         "Spiked Club", [("spiked_club",0)], itp_type_one_handed_wpn|itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip, 83, weight(3)|difficulty(0)|spd_rtng(97) | weapon_length(70)|swing_damage(21 , pierce) | thrust_damage(0 ,  pierce),imodbits_mace ],
["long_spiked_club",         "Long Spiked Club", [("mace_long_c",0)], itp_type_polearm|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_staff|itcf_carry_axe_back, 264, weight(3)|difficulty(0)|spd_rtng(96) | weapon_length(126)|swing_damage(23 , pierce) | thrust_damage(20 ,  blunt),imodbits_mace ],
["club_with_spike_head",  "Spiked Staff", [("mace_e",0)],  itp_type_two_handed_wpn|itp_can_knock_down|itp_primary|itp_wooden_parry, itc_bastardsword|itcf_carry_axe_back, 200 , weight(2.80)|difficulty(0)|spd_rtng(95) | weapon_length(117)|swing_damage(24 , blunt) | thrust_damage(20 ,  pierce),imodbits_mace ],

## Picks
["pickaxe",         "Pickaxe", [("fighting_pick_new",0)], itp_type_one_handed_wpn|itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip,27 , weight(3)|difficulty(0)|spd_rtng(99) | weapon_length(70)|swing_damage(19 , pierce) | thrust_damage(0 ,  pierce),imodbits_pick ],
["fighting_pick", "Fighting Pick", [("fighting_pick_new",0)], itp_type_one_handed_wpn|itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip,108 , weight(1.0)|difficulty(0)|spd_rtng(98) | weapon_length(70)|swing_damage(22 , pierce) | thrust_damage(0 ,  pierce),imodbits_pick ],
["military_pick", "Military Pick", [("steel_pick_new",0)], itp_type_one_handed_wpn|itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip,280 , weight(1.5)|difficulty(0)|spd_rtng(97) | weapon_length(70)|swing_damage(30 , pierce) | thrust_damage(0 ,  pierce),imodbits_pick ],

## Hammers
["hammer", "Hammer", [("iron_hammer_new",0)], itp_type_one_handed_wpn|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_scimitar,7 , weight(2)|difficulty(0)|spd_rtng(100) | weapon_length(55)|swing_damage(24 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],

["military_hammer", "Military Hammer", [("military_hammer",0)], itp_type_one_handed_wpn|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip,317 , weight(2)|difficulty(0)|spd_rtng(95) | weapon_length(70)|swing_damage(31 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["maul", "Maul", [("maul_b",0)], itp_crush_through|itp_type_two_handed_wpn|itp_can_knock_down |itp_primary|itp_two_handed|itp_wooden_parry|itp_wooden_attack|itp_unbalanced, itc_nodachi|itcf_carry_spear,97 , weight(6)|difficulty(11)|spd_rtng(83) | weapon_length(79)|swing_damage(36 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["bec_de_corbin_a",  "War Hammer", [("bec_de_corbin_a",0)], itp_type_polearm| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear|itcf_carry_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(120)|swing_damage(38, blunt) | thrust_damage(38 ,  pierce),imodbits_polearm ],
["sledgehammer", "Sledgehammer", [("maul_c",0)], itp_crush_through|itp_type_two_handed_wpn|itp_can_knock_down|itp_primary|itp_two_handed|itp_wooden_parry|itp_wooden_attack|itp_unbalanced, itc_nodachi|itcf_carry_spear,101 , weight(7)|difficulty(12)|spd_rtng(81) | weapon_length(82)|swing_damage(39, blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["warhammer", "Great Hammer", [("maul_d",0)], itp_crush_through|itp_type_two_handed_wpn|itp_can_knock_down|itp_primary|itp_two_handed|itp_wooden_parry|itp_wooden_attack|itp_unbalanced, itc_nodachi|itcf_carry_spear,290 , weight(9)|difficulty(14)|spd_rtng(79) | weapon_length(75)|swing_damage(45 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["polehammer", "Polehammer", [("pole_hammer",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_two_handed|itp_wooden_parry, itc_staff, 169, weight(7)|difficulty(18)|spd_rtng(50) | weapon_length(126)|swing_damage(50 , blunt) | thrust_damage(35 ,  blunt),imodbits_polearm ],

## Maces
["mace_1", "Spiked Club", [("mace_d",0)], itp_type_one_handed_wpn|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip, 45 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(70)|swing_damage(19 , pierce) | thrust_damage(0 ,  pierce),imodbits_mace ],
["mace_2", "Knobbed_Mace", [("mace_a",0)], itp_type_one_handed_wpn|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip, 98 , weight(2.5)|difficulty(0)|spd_rtng(98) | weapon_length(70)|swing_damage(21 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["sarranid_mace_1", "Iron Mace", [("mace_small_d",0)], itp_type_one_handed_wpn|itp_can_knock_down |itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip, 45 , weight(2.0)|difficulty(0)|spd_rtng(99) | weapon_length(73)|swing_damage(22 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["mace_3", "Spiked Mace", [("mace_c",0)], itp_type_one_handed_wpn|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip, 152 , weight(2.75)|difficulty(0)|spd_rtng(98) | weapon_length(70)|swing_damage(23 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["mace_4", "Winged_Mace", [("mace_b",0)], itp_type_one_handed_wpn|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip, 212 , weight(2.75)|difficulty(0)|spd_rtng(98) | weapon_length(70)|swing_damage(24 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],
["winged_mace", "Flanged Mace", [("flanged_mace",0)], itp_type_one_handed_wpn|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip, 122 , weight(3.5)|difficulty(0)|spd_rtng(103) | weapon_length(70)|swing_damage(24 , blunt) | thrust_damage(0 ,  pierce),imodbits_mace ],

["long_hafted_spiked_mace", "Long Hafted Spiked Mace", [("mace_long_b",0)], itp_type_polearm|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_staff|itcf_carry_axe_back, 310 , weight(3)|difficulty(0)|spd_rtng(94) | weapon_length(140)|swing_damage(28 , blunt) | thrust_damage(26 ,  blunt),imodbits_mace ],
["long_hafted_knobbed_mace", "Long Hafted Knobbed Mace", [("mace_long_a",0)], itp_type_polearm| itp_can_knock_down|itp_primary|itp_wooden_parry, itc_staff|itcf_carry_axe_back, 324 , weight(3)|difficulty(0)|spd_rtng(95) | weapon_length(133)|swing_damage(26 , blunt) | thrust_damage(23 ,  blunt),imodbits_mace ],

["spiked_mace", "Spiked Mace", [("mace_a",0)], itp_type_one_handed_wpn|itp_can_knock_down| itp_primary|itp_wooden_parry, itc_scimitar|itcf_carry_mace_left_hip, 180 , weight(3.5)|difficulty(0)|spd_rtng(98) | weapon_length(70)|swing_damage(30 , blunt) | thrust_damage(0 ,  pierce),imodbits_pick ],

["sarranid_two_handed_mace_1", "Iron Mace", [("mace_long_d",0)], itp_type_two_handed_wpn|itp_can_knock_down|itp_two_handed| itp_primary|itp_crush_through|itp_unbalanced, itc_greatsword|itcf_carry_axe_back,470 , weight(4.5)|difficulty(0)|spd_rtng(90) | weapon_length(95)|swing_damage(35 , blunt) | thrust_damage(22 ,  blunt),imodbits_mace ],
["morningstar", "Morningstar", [("mace_morningstar_new",0)], itp_crush_through|itp_type_two_handed_wpn|itp_primary|itp_wooden_parry|itp_unbalanced, itc_morningstar|itcf_carry_mace_left_hip,305 , weight(4.5)|difficulty(13)|spd_rtng(95) | weapon_length(85)|swing_damage(38 , pierce) | thrust_damage(0 ,  pierce),imodbits_mace ],

## One-handed Swords
["knife",         "Knife", [("peasant_knife_new",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary|itp_no_parry, itc_dagger|itcf_carry_dagger_front_left,18 , weight(0.5)|difficulty(0)|spd_rtng(110) | weapon_length(40)|swing_damage(21 , cut) | thrust_damage(13 ,  pierce),imodbits_sword ],
#["dagger",         "Dagger", [("dagger_b",0),("dagger_b_scabbard",ixmesh_carry),("dagger_b",imodbits_good),("dagger_b_scabbard",ixmesh_carry|imodbits_good)], itp_type_one_handed_wpn|itp_merchandise|itp_primary|itp_secondary|itp_no_parry, itc_dagger|itcf_carry_dagger_front_left|itcf_show_holster_when_drawn, 37 , weight(0.75)|difficulty(0)|spd_rtng(109) | weapon_length(47)|swing_damage(22 , cut) | thrust_damage(19 ,  pierce),imodbits_sword_high ],

["dagger",         "Falchion", [("falshion_1",0),("falshion_1_scab ", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,105 , weight(2.5)|difficulty(0)|spd_rtng(96) | weapon_length(73)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_sword, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["butchering_knife", "Butchering Knife", [("khyber_knife_new",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary|itp_no_parry, itc_dagger|itcf_carry_dagger_front_right,23 , weight(0.75)|difficulty(0)|spd_rtng(108) | weapon_length(60)|swing_damage(24 , cut) | thrust_damage(17 ,  pierce),imodbits_sword ],

["sword_medieval_b_small", "Short Sword", [("crusader_sword_b",0),("crusader_sword_b_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 152 , weight(1)|difficulty(0)|spd_rtng(102) | weapon_length(85)|swing_damage(25, cut) | thrust_damage(22, pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["sword_medieval_b_small1", "Short Sword", [("crusader_sword_c",0),("crusader_sword_c_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 152 , weight(1)|difficulty(0)|spd_rtng(102) | weapon_length(85)|swing_damage(25, cut) | thrust_damage(22, pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["sword_medieval_b_small2", "Short Sword", [("crusaders_swords_a",0),("crusader_sword_a_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 152 , weight(1)|difficulty(0)|spd_rtng(102) | weapon_length(85)|swing_damage(25, cut) | thrust_damage(22, pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["sword_medieval_c_small", "Short Sword", [("crusader_sword_b",0),("crusader_sword_b_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 243 , weight(1)|difficulty(0)|spd_rtng(103) | weapon_length(86)|swing_damage(26, cut) | thrust_damage(24 ,  pierce),imodbits_sword_high ],

["sword_medieval_a", "Sword", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["sword_medieval_a1", "Sword", [("crusader_long_sword_c",0),("crusader_long_sword_c_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["sword_medieval_a2", "Sword", [("crusader_long_sword_a",0),("crusader_long_sword_a_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["sword_medieval_tem", "Templar Sword", [("k_long_sword_a",0),("k_long_sword_a_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_4] ],
["sword_medieval_teu", "Teutonic Sword", [("k_long_sword_b",0),("k_long_sword_b_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2] ],
["sword_medieval_hos", "Hospitaller Sword", [("k_long_sword_c",0),("k_long_sword_c_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_5] ],

["sword_viking_1", "Sword", [("saracin_sword_b",0),("scab_saracin_sword_b ", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 147 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(94)|swing_damage(28 , cut) | thrust_damage(20 ,  pierce),imodbits_sword_high ] ,
["sword_viking_2_small", "Short Sword", [("saracin_sword_b",0),("scab_saracin_sword_b", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 162 , weight(1.25)|difficulty(0)|spd_rtng(103) | weapon_length(85)|swing_damage(28 , cut) | thrust_damage(21 ,  pierce),imodbits_sword_high ],
["sword_medieval_b", "Sword", [("saracin_sword_b",0),("scab_saracin_sword_b", ixmesh_carry),("sword_rusty_a",imodbit_rusty),("sword_rusty_a_scabbard", ixmesh_carry|imodbit_rusty)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 243 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(28 , cut) | thrust_damage(23 ,  pierce),imodbits_sword_high ],
["sword_viking_2", "Sword", [("saracin_sword_b",0),("scab_saracin_sword_b", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 276 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(29 , cut) | thrust_damage(21 ,  pierce),imodbits_sword_high ],
["sword_viking_3_small", "Sword", [("saracin_sword_b",0),("scab_saracin_sword_b", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 280 , weight(1.25)|difficulty(0)|spd_rtng(103) | weapon_length(86)|swing_damage(29 , cut) | thrust_damage(21 ,  pierce),imodbits_sword_high ],
["sword_medieval_c", "Sword", [("saracin_sword_b",0),("scab_saracin_sword_b", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 410 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(29 , cut) | thrust_damage(24 ,  pierce),imodbits_sword_high ],
["sword_medieval_c_long", "Sword", [("saracin_sword_b",0),("scab_saracin_sword_b", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 480 , weight(1.7)|difficulty(0)|spd_rtng(99) | weapon_length(100)|swing_damage(29 , cut) | thrust_damage(28 ,  pierce),imodbits_sword_high ],
["sword_viking_3", "Sword", [("saracin_sword_b",0),("scab_saracin_sword_b", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 394 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(30 , cut) | thrust_damage(21 ,  pierce),imodbits_sword_high ],

["falchion", "Falchion", [("falshion_1",0),("falshion_1_scab ", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,105 , weight(2.5)|difficulty(0)|spd_rtng(96) | weapon_length(73)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_sword, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["falchion_sar", "Arabian Falchion", [("falshion_2",0)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_sword_left_hip,105 , weight(2.5)|difficulty(0)|spd_rtng(96) | weapon_length(73)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_sword, [], [fac_kingdom_3,fac_kingdom_6] ],

["sword_medieval_d_long", "Sword", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 550 , weight(1.8)|difficulty(0)|spd_rtng(96) | weapon_length(105)|swing_damage(33 , cut) | thrust_damage(28 ,  pierce),imodbits_sword ],

## Bastard Swords
["bastard_sword_a", "Bastard Sword", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise| itp_primary, itc_bastardsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 294 , weight(2.0)|difficulty(0)|spd_rtng(98) | weapon_length(101)|swing_damage(32 , cut) | thrust_damage(26 ,  pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["bastard_sword_a1", "Bastard Sword", [("crusader_long_sword_c",0),("crusader_long_sword_c_scabbard", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise| itp_primary, itc_bastardsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 294 , weight(2.0)|difficulty(0)|spd_rtng(98) | weapon_length(101)|swing_damage(32 , cut) | thrust_damage(26 ,  pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["bastard_sword_a2", "Bastard Sword", [("crusader_long_sword_a",0),("crusader_long_sword_a_scabbard", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise| itp_primary, itc_bastardsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 294 , weight(2.0)|difficulty(0)|spd_rtng(98) | weapon_length(101)|swing_damage(32 , cut) | thrust_damage(26 ,  pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["bastard_sword_tem", "Templar Bastard Sword", [("k_long_sword_a",0),("k_long_sword_a_scabbard", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise| itp_primary, itc_bastardsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 294 , weight(2.0)|difficulty(0)|spd_rtng(98) | weapon_length(101)|swing_damage(32 , cut) | thrust_damage(26 ,  pierce),imodbits_sword_high, [], [fac_kingdom_4] ],
["bastard_sword_teu", "Teutonic Bastard Sword", [("k_long_sword_b",0),("k_long_sword_b_scabbard", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise| itp_primary, itc_bastardsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 294 , weight(2.0)|difficulty(0)|spd_rtng(98) | weapon_length(101)|swing_damage(32 , cut) | thrust_damage(26 ,  pierce),imodbits_sword_high, [], [fac_kingdom_1,fac_kingdom_2] ],
["bastard_sword_hos", "Hospitaller Bastard Sword", [("k_long_sword_c",0),("k_long_sword_c_scabbard", ixmesh_carry)], itp_type_two_handed_wpn|itp_merchandise| itp_primary, itc_bastardsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 294 , weight(2.0)|difficulty(0)|spd_rtng(98) | weapon_length(101)|swing_damage(32 , cut) | thrust_damage(26 ,  pierce),imodbits_sword_high, [], [fac_kingdom_5] ],

["bastard_sword_b", "Heavy Bastard Sword", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_two_handed_wpn| itp_primary, itc_bastardsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 526 , weight(2.25)|difficulty(9)|spd_rtng(97) | weapon_length(105)|swing_damage(37 , cut) | thrust_damage(27 ,  pierce),imodbits_sword_high ],

## Two-handed Swords
["great_sword", "Great Sword", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_two_handed_wpn| itp_two_handed|itp_primary, itc_greatsword|itcf_carry_sword_back|itcf_show_holster_when_drawn, 423 , weight(2.75)|difficulty(10)|spd_rtng(95) | weapon_length(125)|swing_damage(39 , cut) | thrust_damage(31 ,  pierce),imodbits_sword_high ],
["sword_of_war", "Sword of War", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_two_handed_wpn| itp_two_handed|itp_primary, itc_greatsword|itcf_carry_sword_back|itcf_show_holster_when_drawn, 524 , weight(3)|difficulty(11)|spd_rtng(94) | weapon_length(130)|swing_damage(40 , cut) | thrust_damage(31 ,  pierce),imodbits_sword_high ],
["sword_two_handed_b", "Two Handed Sword", [("crusader_long_sword_b",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary, itc_greatsword|itcf_carry_sword_back, 670 , weight(2.75)|difficulty(10)|spd_rtng(97) | weapon_length(110)|swing_damage(40 , cut) | thrust_damage(28 ,  pierce),imodbits_sword_high ],
["sword_two_handed_a", "Great Sword", [("crusader_long_sword_b",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary, itc_greatsword|itcf_carry_sword_back, 1123 , weight(2.75)|difficulty(10)|spd_rtng(96) | weapon_length(120)|swing_damage(42 , cut) | thrust_damage(29 ,  pierce),imodbits_sword_high ],

## One-handed Scimitars/Sabres
["arabian_sword_a",         "Sword", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,108 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(97)|swing_damage(26 , cut) | thrust_damage(19 ,  pierce),imodbits_sword_high ],
["arabian_sword_b",         "Arming Sword", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,218 , weight(1.7)|difficulty(0)|spd_rtng(99) | weapon_length(97)|swing_damage(28 , cut) | thrust_damage(19 ,  pierce),imodbits_sword_high ],
["sarranid_cavalry_sword",         "Cavalry Sword", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,310 , weight(1.5)|difficulty(0)|spd_rtng(98) | weapon_length(105)|swing_damage(28 , cut) | thrust_damage(19 ,  pierce),imodbits_sword_high ],
["sword_khergit_1", "Nomad Sabre", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 105 , weight(1.25)|difficulty(0)|spd_rtng(100) | weapon_length(97)|swing_damage(29 , cut),imodbits_sword_high ],

["sword_arabian_small", "Arabian Short Sword", [("saracin_sword_b",0),("scab_saracin_sword_b", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 152 , weight(1)|difficulty(0)|spd_rtng(102) | weapon_length(85)|swing_damage(25, cut) | thrust_damage(22, pierce),imodbits_sword_high, [], [fac_kingdom_3,fac_kingdom_6] ],

#["scimitar",         "Scimitar", [("scimitar_a",0),("scab_scimeter_a", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,210 , weight(1.5)|difficulty(0)|spd_rtng(101) | weapon_length(97)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_sword_high, [], [fac_kingdom_3,fac_kingdom_6] ],
#["scimitar1",         "Scimitar", [("scimitar_b",0),("scab_scimeter_b", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,210 , weight(1.5)|difficulty(0)|spd_rtng(101) | weapon_length(97)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_sword_high, [], [fac_kingdom_3,fac_kingdom_6] ],

["scimitar", "Arabian Sword", [("saracin_sword_c",0),("scab_saracin_sword_c", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_3,fac_kingdom_6] ],
["scimitar1", "Arabian Sword", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_3,fac_kingdom_6] ],
["scimitar2", "Arabian Sword", [("saracin_sword_a",0),("scab_saracin_sword_a", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_3,fac_kingdom_6] ],
["scimitar3", "Arabian Sword", [("saracin_sword_e",0),("scab_saracin_sword_e", ixmesh_carry)], itp_type_one_handed_wpn|itp_merchandise|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high, [], [fac_kingdom_3,fac_kingdom_6] ],

["sword_khergit_2", "Sabre", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 191 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(97)|swing_damage(30 , cut),imodbits_sword_high ],
["arabian_sword_d",         "Guard Sword", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,420 , weight(1.7)|difficulty(0)|spd_rtng(99) | weapon_length(97)|swing_damage(30 , cut) | thrust_damage(20 ,  pierce),imodbits_sword_high ],
["sword_khergit_3", "Sabre", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 294 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(98)|swing_damage(31 , cut),imodbits_sword_high ],
["scimitar_b",         "Elite Scimitar", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn,290 , weight(1.5)|difficulty(0)|spd_rtng(100) | weapon_length(103)|swing_damage(32 , cut) | thrust_damage(0 ,  pierce),imodbits_sword_high ],
["sword_khergit_4", "Heavy Sabre", [("saracin_sword_d",0),("scab_saracin_sword_d", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 384 , weight(1.75)|difficulty(0)|spd_rtng(98) | weapon_length(96)|swing_damage(33 , cut),imodbits_sword_high ],

## Two-handed Scimitars/Sabres
["khergit_sword_two_handed_a",         "Two Handed Sabre", [("saracin_sword_d",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary, itc_nodachi|itcf_carry_sword_back, 523 , weight(2.75)|difficulty(10)|spd_rtng(96) | weapon_length(120)|swing_damage(40 , cut) | thrust_damage(0 ,  pierce),imodbits_sword_high ],
["khergit_sword_two_handed_b",         "Two Handed Sabre", [("saracin_sword_d",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary, itc_nodachi|itcf_carry_sword_back, 920 , weight(2.75)|difficulty(10)|spd_rtng(96) | weapon_length(120)|swing_damage(44 , cut) | thrust_damage(0 ,  pierce),imodbits_sword_high ],

## Cleavers
["cleaver",         "Cleaver", [("cleaver_new",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary|itp_no_parry|itp_wooden_parry, itc_cleaver,14 , weight(1.5)|difficulty(0)|spd_rtng(103) | weapon_length(35)|swing_damage(24 , cut) | thrust_damage(0 ,  pierce),imodbits_none ],

["military_cleaver_b", "Soldier's Cleaver", [("military_cleaver_b",0)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip, 193 , weight(1.5)|difficulty(0)|spd_rtng(96) | weapon_length(95)|swing_damage(31 , cut) | thrust_damage(0 ,  pierce),imodbits_sword_high ],
["military_cleaver_c", "Military Cleaver", [("military_cleaver_c",0)], itp_type_one_handed_wpn|itp_primary, itc_scimitar|itcf_carry_sword_left_hip, 263 , weight(1.5)|difficulty(0)|spd_rtng(96) | weapon_length(95)|swing_damage(35 , cut) | thrust_damage(0 ,  pierce),imodbits_sword_high ],
["two_handed_cleaver", "War Cleaver", [("military_cleaver_a",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary, itc_nodachi|itcf_carry_sword_back, 640 , weight(2.75)|difficulty(10)|spd_rtng(93) | weapon_length(120)|swing_damage(45 , cut) | thrust_damage(0 ,  cut),imodbits_sword_high ],

## One-handed Axes
["hatchet",         "Hatchet", [("axe_crusader_a",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip,13 , weight(2)|difficulty(0)|spd_rtng(97) | weapon_length(60)|swing_damage(23 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["hand_axe",         "Hand Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip,24 , weight(2)|difficulty(0)|spd_rtng(95) | weapon_length(75)|swing_damage(27 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],

["fighting_axe", "Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip,77 , weight(2.5)|difficulty(0)|spd_rtng(92) | weapon_length(90)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_axe, [], [fac_kingdom_3,fac_kingdom_6] ],
["axe_cru1", "Axe", [("axe_crusader_b",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip,77 , weight(2.5)|difficulty(0)|spd_rtng(92) | weapon_length(90)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_axe, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["axe_cru2", "Axe", [("axe_crusader_c",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip,77 , weight(2.5)|difficulty(0)|spd_rtng(92) | weapon_length(90)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_axe, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["axe_cru3", "Axe", [("axe_crusader_d",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip,77 , weight(2.5)|difficulty(0)|spd_rtng(92) | weapon_length(90)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_axe, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["axe_cru4", "Axe", [("axe_crusader_1",0)], itp_type_one_handed_wpn|itp_merchandise| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip,77 , weight(2.5)|difficulty(0)|spd_rtng(92) | weapon_length(90)|swing_damage(30 , cut) | thrust_damage(0 ,  pierce),imodbits_axe, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["one_handed_war_axe_a", "One Handed Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip, 87 , weight(1.5)|difficulty(9)|spd_rtng(98) | weapon_length(71)|swing_damage(32 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["one_handed_battle_axe_a", "One Handed Battle Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip, 142 , weight(1.5)|difficulty(9)|spd_rtng(98) | weapon_length(73)|swing_damage(34 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["one_handed_war_axe_b", "One Handed War Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip, 190 , weight(1.5)|difficulty(9)|spd_rtng(98) | weapon_length(76)|swing_damage(34 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["sarranid_axe_a", "Iron Battle Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip, 250 , weight(1.65)|difficulty(9)|spd_rtng(97) | weapon_length(71)|swing_damage(35 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["one_handed_battle_axe_b", "One Handed Battle Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip, 230 , weight(1.75)|difficulty(9)|spd_rtng(98) | weapon_length(72)|swing_damage(36 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["one_handed_battle_axe_c", "One Handed Battle Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip, 550 , weight(2.0)|difficulty(9)|spd_rtng(98) | weapon_length(76)|swing_damage(37 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["sarranid_axe_b", "Iron War Axe", [("axe_crusader_a",0)], itp_type_one_handed_wpn| itp_primary|itp_secondary|itp_bonus_against_shield|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip, 360 , weight(1.75)|difficulty(9)|spd_rtng(97) | weapon_length(71)|swing_damage(38 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],

## Two-handed Axes
["axe",                 "Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_nodachi|itcf_carry_axe_back,65 , weight(4)|difficulty(8)|spd_rtng(91) | weapon_length(108)|swing_damage(32 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["two_handed_axe",         "Two Handed Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced, itc_nodachi|itcf_carry_axe_back, 90 , weight(4.5)|difficulty(10)|spd_rtng(96) | weapon_length(90)|swing_damage(38 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["battle_axe",         "Battle Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_nodachi|itcf_carry_axe_back,240 , weight(5)|difficulty(9)|spd_rtng(88) | weapon_length(108)|swing_damage(41 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["war_axe",         "War Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_nodachi|itcf_carry_axe_back,264 , weight(5)|difficulty(10)|spd_rtng(86) | weapon_length(110)|swing_damage(43 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["two_handed_battle_axe_2",         "Two Handed War Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced, itc_nodachi|itcf_carry_axe_back, 152 , weight(4.5)|difficulty(10)|spd_rtng(96) | weapon_length(92)|swing_damage(44 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["sarranid_two_handed_axe_b",         "War Axe", [("axe_crusader_a",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary|itp_bonus_against_shield|itp_unbalanced, itc_nodachi|itcf_carry_axe_back, 280 , weight(2.50)|difficulty(10)|spd_rtng(90) | weapon_length(90)|swing_damage(46 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["great_axe",         "Great Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced, itc_nodachi|itcf_carry_axe_back, 316 , weight(4.5)|difficulty(10)|spd_rtng(94) | weapon_length(96)|swing_damage(47 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["sarranid_two_handed_axe_a",         "Battle Axe", [("axe_crusader_a",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary|itp_bonus_against_shield|itp_unbalanced, itc_nodachi|itcf_carry_axe_back, 350 , weight(3.0)|difficulty(10)|spd_rtng(89) | weapon_length(95)|swing_damage(49 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["poleaxe",         "Poleaxe", [("pole_ax",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_two_handed|itp_wooden_parry, itc_staff, 384 , weight(4.5)|difficulty(13)|spd_rtng(77) | weapon_length(180)|swing_damage(50 , cut) | thrust_damage(15 ,  blunt),imodbits_polearm ],

## Two-handed Axes with alternative weapon mode
["long_axe",         "Long Axe", [("axe_crusader_1",0)], itp_type_polearm|itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_next_item_as_melee|itp_unbalanced,itc_staff|itcf_carry_axe_back, 390 , weight(4.75)|difficulty(10)|spd_rtng(93) | weapon_length(120)|swing_damage(46 , cut) | thrust_damage(19 ,  blunt),imodbits_axe ],
["long_axe_alt",         "Long Axe", [("axe_crusader_1",0)],itp_type_two_handed_wpn|itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced|itp_crush_through, itc_nodachi|itcf_carry_axe_back, 390 , weight(4.75)|difficulty(10)|spd_rtng(88) | weapon_length(120)|swing_damage(46 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ], ## CC
["long_axe_b",         "Long War Axe", [("axe_crusader_1",0)], itp_type_polearm| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_next_item_as_melee|itp_unbalanced, itc_staff|itcf_carry_axe_back, 510 , weight(5.0)|difficulty(10)|spd_rtng(92) | weapon_length(125)|swing_damage(50 , cut) | thrust_damage(18 ,  blunt),imodbits_axe ],
["long_axe_b_alt",         "Long War Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced|itp_crush_through, itc_nodachi|itcf_carry_axe_back, 510 , weight(5.0)|difficulty(10)|spd_rtng(87) | weapon_length(125)|swing_damage(50 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ], ## CC
["long_axe_c",         "Great Long Axe", [("axe_crusader_1",0)], itp_type_polearm| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_next_item_as_melee|itp_unbalanced, itc_staff|itcf_carry_axe_back, 660 , weight(5.5)|difficulty(10)|spd_rtng(91) | weapon_length(127)|swing_damage(54 , cut) | thrust_damage(19 ,  blunt),imodbits_axe ],
["long_axe_c_alt",      "Great Long Axe", [("axe_crusader_1",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced|itp_crush_through, itc_nodachi|itcf_carry_axe_back, 660 , weight(5.5)|difficulty(10)|spd_rtng(85) | weapon_length(127)|swing_damage(54 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ], ## CC

## Bardiches
["bardiche",         "Bardiche", [("two_handed_battle_axe_d",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced, itc_nodachi|itcf_carry_axe_back, 291 , weight(4.75)|difficulty(10)|spd_rtng(91) | weapon_length(102)|swing_damage(47 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["great_bardiche",         "Great Bardiche", [("two_handed_battle_axe_f",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced, itc_nodachi|itcf_carry_axe_back, 617 , weight(5.0)|difficulty(10)|spd_rtng(89) | weapon_length(116)|swing_damage(50 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["long_bardiche",         "Long Bardiche", [("two_handed_battle_long_axe_b",0)], itp_type_polearm| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_staff,390 , weight(4.75)|difficulty(11)|spd_rtng(89) | weapon_length(140)|swing_damage(48 , cut) | thrust_damage(17 ,  pierce),imodbits_axe ],
["great_long_bardiche",         "Great Long Bardiche", [("two_handed_battle_long_axe_c",0)], itp_type_polearm| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_staff, 660 , weight(5.0)|difficulty(12)|spd_rtng(88) | weapon_length(155)|swing_damage(50 , cut) | thrust_damage(17 ,  pierce),imodbits_axe ],

## Voulges
["voulge",         "Voulge", [("voulge",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_nodachi|itcf_carry_axe_back,129 , weight(4.5)|difficulty(8)|spd_rtng(87) | weapon_length(119)|swing_damage(35 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
# Voulge was renamed to long_voulge. Two weapons with the same name might cause trouble
["long_voulge",         "Long Voulge", [("two_handed_battle_long_axe_a",0)], itp_type_polearm| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_staff,
 120 , weight(3.0)|difficulty(10)|spd_rtng(88) | weapon_length(175)|swing_damage(40 , cut) | thrust_damage(18 ,  pierce),imodbits_axe ],
["shortened_voulge",         "Shortened Voulge", [("two_handed_battle_axe_c",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced, itc_nodachi|itcf_carry_axe_back, 228 , weight(4.5)|difficulty(10)|spd_rtng(92) | weapon_length(100)|swing_damage(45 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],


## Voulges
["voulge",         "Voulge", [("voulge",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_nodachi|itcf_carry_axe_back,129 , weight(4.5)|difficulty(0)|spd_rtng(87) | weapon_length(119)|swing_damage(35 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],

# Voulge was renamed to long_voulge. Two weapons with the same name might cause trouble
["long_voulge",         "Long Voulge", [("two_handed_battle_long_axe_a",0)], itp_type_polearm| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry, itc_staff,
 120 , weight(3.0)|difficulty(10)|spd_rtng(88) | weapon_length(175)|swing_damage(40 , cut) | thrust_damage(18 ,  pierce),imodbits_axe ],
["shortened_voulge",         "Shortened Voulge", [("two_handed_battle_axe_c",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary|itp_bonus_against_shield|itp_wooden_parry|itp_unbalanced, itc_nodachi|itcf_carry_axe_back, 228 , weight(4.5)|difficulty(10)|spd_rtng(92) | weapon_length(100)|swing_damage(45 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],

## Sickles
["sickle", "Sickle", [("sickle",0)], itp_type_one_handed_wpn|itp_primary|itp_secondary|itp_no_parry|itp_wooden_parry, itc_cleaver,9 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(40)|swing_damage(20 , cut) | thrust_damage(0 ,  pierce),imodbits_none ],

["military_sickle_a", "Military Sickle", [("military_sickle_a",0)], itp_type_one_handed_wpn| itp_primary|itp_secondary|itp_wooden_parry, itc_scimitar|itcf_carry_axe_left_hip, 220 , weight(1.0)|difficulty(9)|spd_rtng(100) | weapon_length(75)|swing_damage(26 , pierce) | thrust_damage(0 ,  pierce),imodbits_axe ],

## Scythes
["scythe", "Scythe", [("scythe",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_staff|itcf_carry_spear, 43 , weight(2)|difficulty(0)|spd_rtng(97) | weapon_length(182)|swing_damage(30 , cut) | thrust_damage(14 ,  pierce),imodbits_polearm ],

["military_scythe", "Military Scythe", [("spear_e_2-5m",0),("spear_c_2-5m",imodbits_bad)], itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_staff|itcf_carry_spear, 155 , weight(2.5)|difficulty(0)|spd_rtng(90) | weapon_length(155)|swing_damage(36 , cut) | thrust_damage(25 ,  pierce),imodbits_polearm ],
["shortened_military_scythe", "Shortened Military Scythe", [("two_handed_battle_scythe_a",0)], itp_type_two_handed_wpn| itp_two_handed|itp_primary, itc_nodachi|itcf_carry_sword_back, 264 , weight(3.0)|difficulty(10)|spd_rtng(90) | weapon_length(112)|swing_damage(45 , cut) | thrust_damage(0 ,  pierce),imodbits_sword_high ],

## Forks
["pitch_fork",         "Pitch Fork", [("pitch_fork",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry,itc_staff, 19 , weight(1.5)|difficulty(0)|spd_rtng(87) | weapon_length(154)|swing_damage(16 , blunt) | thrust_damage(22 ,  pierce),imodbits_polearm ],

["military_fork", "Military Fork", [("military_fork",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_wooden_parry,itc_staff, 153 , weight(2)|difficulty(0)|spd_rtng(95) | weapon_length(135)|swing_damage(15 , blunt) | thrust_damage(30 ,  pierce),imodbits_polearm ],
["battle_fork",         "Battle Fork", [("battle_fork",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_wooden_parry,itc_staff, 282 , weight(2.2)|difficulty(0)|spd_rtng(90) | weapon_length(144)|swing_damage(15, blunt) | thrust_damage(35 ,  pierce),imodbits_polearm ],

## Staves
["staff",         "Staff", [("wooden_staff",0)], itp_type_polearm| itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_wooden_attack, itc_staff|itcf_carry_sword_back, 36 , weight(1.5)|difficulty(0)|spd_rtng(100) | weapon_length(130)|swing_damage(18 , blunt) | thrust_damage(19 ,  blunt),imodbits_polearm ],
["quarter_staff", "Quarter Staff", [("quarter_staff",0)], itp_type_polearm| itp_offset_lance| itp_primary|itp_wooden_parry|itp_wooden_attack, itc_staff|itcf_carry_sword_back, 60 , weight(2)|difficulty(0)|spd_rtng(104) | weapon_length(140)|swing_damage(20 , blunt) | thrust_damage(20 ,  blunt),imodbits_polearm ],
["iron_staff",         "Iron Staff", [("iron_staff",0)], itp_type_polearm|itp_offset_lance| itp_primary, itc_staff|itcf_carry_sword_back, 202 , weight(2)|difficulty(0)|spd_rtng(97) | weapon_length(140)|swing_damage(25 , blunt) | thrust_damage(26 ,  blunt),imodbits_polearm ],

## Hafted Blades
["hafted_blade_b", "Hafted Blade", [("khergit_pike_b",0)], itp_type_polearm| itp_primary|itp_two_handed|itp_penalty_with_shield|itp_wooden_parry, itcf_carry_spear|itc_guandao, 185 , weight(2.75)|difficulty(0)|spd_rtng(95) | weapon_length(135)|swing_damage(37 , cut) | thrust_damage(20 ,  pierce),imodbits_polearm ],
["hafted_blade_a", "Hafted Blade", [("khergit_pike_a",0)], itp_type_polearm| itp_primary|itp_two_handed|itp_penalty_with_shield|itp_wooden_parry, itcf_carry_spear|itc_guandao, 350 , weight(3.25)|difficulty(0)|spd_rtng(93) | weapon_length(153)|swing_damage(39 , cut) | thrust_damage(19 ,  pierce),imodbits_polearm ],

## Spears
["bamboo_spear", "Bamboo Spear", [("saracin_spears_a",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_staff|itcf_carry_spear, 80 , weight(2.0)|difficulty(0)|spd_rtng(88) | weapon_length(200)|swing_damage(15 , blunt) | thrust_damage(20 ,  pierce),imodbits_polearm ],
["shortened_spear", "Shortened Spear", [("saracin_spears_a",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_wooden_parry, itc_staff|itcf_carry_spear, 53 , weight(2.0)|difficulty(0)|spd_rtng(102) | weapon_length(120)|swing_damage(19 , blunt) | thrust_damage(25 ,  pierce),imodbits_polearm ],

["spear", "Spear", [("saracin_spears_a",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_wooden_parry, itc_staff|itcf_carry_spear, 85 , weight(2.25)|difficulty(0)|spd_rtng(98) | weapon_length(135)|swing_damage(20 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm ],

["war_spear", "War Spear", [("crusader_spear_b",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_wooden_parry, itc_staff|itcf_carry_spear,  140 , weight(2.5)|difficulty(0)|spd_rtng(95) | weapon_length(150)|swing_damage(20 , blunt) | thrust_damage(27 ,  pierce),imodbits_polearm ],
["boar_spear", "Boar Spear", [("crusader_spear_b",0)], itp_type_polearm| itp_primary|itp_penalty_with_shield|itp_wooden_parry,itc_staff|itcf_carry_spear,76 , weight(1.5)|difficulty(0)|spd_rtng(90) | weapon_length(157)|swing_damage(26 , cut) | thrust_damage(23 ,  pierce),imodbits_polearm ],

## Glaives
["glaive", "Glaive", [("glaive_b",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_two_handed|itp_wooden_parry, itc_staff|itcf_carry_spear, 352 , weight(4.5)|difficulty(0)|spd_rtng(90) | weapon_length(157)|swing_damage(39 , cut) | thrust_damage(21 ,  pierce),imodbits_polearm ],

## Lances
["double_sided_lance", "Double Sided Lance", [("lance_dblhead",0)], itp_couchable|itp_type_polearm|itp_offset_lance| itp_primary|itp_wooden_parry|itp_crush_through, itc_staff, 261 , weight(4.0)|difficulty(0)|spd_rtng(95) | weapon_length(128)|swing_damage(25, cut) | thrust_damage(27 ,  pierce),imodbits_polearm ], ## CC
## CC
["light_lance", "Light Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 180 , weight(2.5)|difficulty(0)|spd_rtng(85) | weapon_length(175)|swing_damage(16 , blunt) | thrust_damage(27 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["lance", "Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 270 , weight(2.5)|difficulty(0)|spd_rtng(80) | weapon_length(180)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm ],

["heavy_lance", "Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["lance_banner_jer", "Jerusalem Lance", [("spear_baner_jerusalem_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],
["lance_banner_jer1", "Jerusalem Lance", [("spear_baner_jerusalem_c",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],
["lance_banner_jer2", "Jerusalem Lance", [("spear_baner_jerusalem_e",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],
["lance_banner_jer3", "Jerusalem Lance", [("spear_baner_jerusalem_b",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],

["lance_banner_ibe", "Jerusalem Lance", [("spear_baner_ibelin_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],
["lance_banner_ibe1", "Jerusalem Lance", [("spear_baner_ibelin_c",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],
["lance_banner_ibe2", "Jerusalem Lance", [("spear_baner_ibelin_g",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],
["lance_banner_ibe3", "Jerusalem Lance", [("spear_baner_ibelin_b",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],

["lance_banner_ant", "Antioch Lance", [("spear_baner_antiohia_b",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],
["lance_banner_ant1", "Antioch Lance", [("spear_baner_antiohia_d",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],
["lance_banner_ant2", "Antioch Lance", [("spear_baner_antiohia_f",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],
["lance_banner_ant3", "Antioch Lance", [("spear_baner_antiohia_c",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],

["lance_banner_tri", "Antioch Lance", [("spear_baner_tripol_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],
["lance_banner_tri1", "Antioch Lance", [("spear_baner_tripol_c",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],
["lance_banner_tri2", "Antioch Lance", [("spear_baner_tripol_f",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],
["lance_banner_tri3", "Antioch Lance", [("spear_baner_tripol_b",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],

["lance_banner_tem", "Templar Lance", [("spear_baner_templar_b",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],
["lance_banner_tem1", "Templar Lance", [("spear_baner_templar_e",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],
["lance_banner_tem2", "Templar Lance", [("spear_baner_templar_h",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],
["lance_banner_tem3", "Templar Lance", [("spear_baner_templar_c",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],

["lance_banner_tem4", "Templar Lance", [("spear_baner_templar_g",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],
["lance_banner_tem5", "Templar Lance", [("spear_baner_templar_k",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],
["lance_banner_tem6", "Templar Lance", [("spear_baner_templar_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],
["lance_banner_tem7", "Templar Lance", [("spear_baner_templar_d",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],

["lance_banner_hos", "Hospitaller Lance", [("spear_baner_hospillers_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_5] ],
["lance_banner_hos1", "Hospitaller Lance", [("spear_baner_hospillers_d",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_5] ],
["lance_banner_hos2", "Hospitaller Lance", [("spear_baner_hospillers_f",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_5] ],

["lance_banner_hos3", "Hospitaller Lance", [("spear_baner_hospillers_c",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_5] ],
["lance_banner_hos4", "Hospitaller Lance", [("spear_baner_hospillers_b",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_5] ],
["lance_banner_hos5", "Hospitaller Lance", [("spear_baner_hospillers_e",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_5] ],

["lance_banner_teu", "Teutonic Lance", [("spear_baner_tevton_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],
["lance_banner_teu1", "Teutonic Lance", [("spear_baner_tevton_e",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],
["lance_banner_teu2", "Teutonic Lance", [("spear_baner_tevton_f",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],
["lance_banner_teu3", "Teutonic Lance", [("spear_baner_tevton_b",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],

["lance_banner_teu4", "Teutonic Lance", [("spear_baner_tevton_d",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],
["lance_banner_teu5", "Teutonic Lance", [("spear_baner_tevton_c",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],

["lance_sar", "Arabian Lance", [("mameluk_spears_b",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 180 , weight(2.5)|difficulty(0)|spd_rtng(85) | weapon_length(175)|swing_damage(16 , blunt) | thrust_damage(27 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["lance_sar1", "Arabian Lance", [("mameluk_spears_c",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 180 , weight(2.5)|difficulty(0)|spd_rtng(85) | weapon_length(175)|swing_damage(16 , blunt) | thrust_damage(27 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["lance_sar2", "Arabian Lance", [("mameluk_spears_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 180 , weight(2.5)|difficulty(0)|spd_rtng(85) | weapon_length(175)|swing_damage(16 , blunt) | thrust_damage(27 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],

["lance_banner_sar", "Muslim Lance", [("spear_baner_saracin_b",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["lance_banner_sar1", "Muslim Lance", [("spear_baner_saracin_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],

["lance_banner_sar2", "Muslim Lance", [("spear_baner_saracin_d",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["lance_banner_sar3", "Muslim Lance", [("spear_baner_saracin_c",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],

["lance_banner_sar4", "Muslim Lance", [("spear_baner_saracin_e",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["lance_banner_sar5", "Muslim Lance", [("spear_baner_saracin_f",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["lance_banner_sar6", "Muslim Lance", [("spear_baner_saracin_g",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_merchandise| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 360 , weight(2.75)|difficulty(0)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],

["great_lance", "Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm| itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_greatlance,  410 , weight(5)|difficulty(11)|spd_rtng(55) | weapon_length(240)|swing_damage(0 , cut) | thrust_damage(21 ,  pierce),imodbits_polearm ],

## CC
["jousting_lance", "Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_greatlance, 158 , weight(5)|difficulty(0)|spd_rtng(61) | weapon_length(240)|swing_damage(0 , cut) | thrust_damage(17 ,  blunt),imodbits_polearm ],

## Pikes
["pike", "Pike", [("crusader_knight_spear_a",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
#["ashwood_pike", "Pike", [("spear_b_2-75m",0)], itp_type_polearm|itp_merchandise|itp_offset_lance| itp_primary|itp_two_handed|itp_wooden_parry, itc_cutting_spear, 205 , weight(3.5)|difficulty(0)|spd_rtng(90) | weapon_length(170)|swing_damage(19 , blunt) | thrust_damage(29,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["pike_banner_jer", "Jerusalem Pike", [("spear_baner_jerusalem_a",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],
["pike_banner_jer1", "Jerusalem Pike", [("spear_baner_ibelin_b",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1] ],

["pike_banner_ant", "Antioch Pike", [("spear_baner_antiohia_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],
["pike_banner_ant1", "Antioch Pike", [("spear_baner_tripol_b",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_2] ],

["pike_banner_tem", "Templar Pike", [("spear_baner_templar_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],
["pike_banner_tem1", "Templar Pike", [("spear_baner_templar_d",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_4] ],

["pike_banner_hos", "Hospitaller Pike", [("spear_baner_hospillers_a",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_5] ],
["pike_banner_hos1", "Hospitaller Pike", [("spear_baner_hospillers_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_5] ],

["pike_banner_teu", "Teutonic Pike", [("spear_baner_tevton_d",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],
["pike_banner_teu1", "Teutonic Pike", [("spear_baner_tevton_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],

["battlefield_cross", "Staff", [("battlefield_cross",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["cross_jer", "Jerusalem Staff", [("flag_jerusalem_a",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_1] ],
["cross_jer1", "Jerusalem Staff", [("flag_ibelin_b",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_1] ],

["cross_ant", "Antioch Staff", [("flag_antiohia_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_2] ],
["cross_ant1", "Antioch Staff", [("flag_tripol_b",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_2] ],

["cross_tem", "Templar Staff", [("flag_templar_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_4] ],
["cross_tem1", "Templar Staff", [("flag_templar_d",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_4] ],

["cross_hos", "Hospitaller Staff", [("flag_hospillers_a",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_5] ],
["cross_hos1", "Hospitaller Staff", [("flag_hospillers_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_5] ],

["cross_teu", "Teutonic Staff", [("flag_tevton_d",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],
["cross_teu1", "Teutonic Staff", [("flag_tevton_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2] ],

["battlefield_crescent", "Staff", [("battlefield_crescent",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],

["crescent_sar", "Muslim Staff", [("flag_saracin_b",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["crescent_sar1", "Muslim Staff", [("flag_saracin_a",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["crescent_sar2", "Muslim Staff", [("flag_saracin_d",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["crescent_sar3", "Muslim Staff", [("flag_saracin_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_staff, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(23 ,  blunt),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],

["ashwood_pike", "Pike", [("crusader_spear_b",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_offset_lance| itp_primary|itp_two_handed|itp_wooden_parry, itc_cutting_spear, 205 , weight(3.5)|difficulty(0)|spd_rtng(90) | weapon_length(170)|swing_damage(19 , blunt) | thrust_damage(29,  pierce),imodbits_polearm, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["muslim_pike1", "Pike", [("crusader_knight_spear_b",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],

["pike_banner_sar", "Muslim Pike", [("spear_baner_saracin_b",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["pike_banner_sar1", "Muslim Pike", [("spear_baner_saracin_a",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["pike_banner_sar2", "Muslim Pike", [("spear_baner_saracin_d",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],
["pike_banner_sar3", "Muslim Pike", [("spear_baner_saracin_c",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_two_handed, itc_cutting_spear, 125 , weight(3.0)|difficulty(0)|spd_rtng(81) | weapon_length(245)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],

["muslim_pike", "Pike", [("saracin_spears_a",0)], itp_type_polearm|itp_merchandise| itp_cant_use_on_horseback|itp_offset_lance| itp_primary|itp_two_handed|itp_wooden_parry, itc_cutting_spear, 205 , weight(3.5)|difficulty(0)|spd_rtng(90) | weapon_length(170)|swing_damage(19 , blunt) | thrust_damage(29,  pierce),imodbits_polearm, [], [fac_kingdom_3,fac_kingdom_6] ],

["awlpike", "Pike", [("crusader_knight_spear_a",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_cutting_spear|itcf_carry_spear, 345 , weight(2.25)|difficulty(0)|spd_rtng(92) | weapon_length(165)|swing_damage(20 , blunt) | thrust_damage(33 ,  pierce),imodbits_polearm ],
["awlpike_long", "Pike", [("crusader_knight_spear_a",0)], itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_cutting_spear|itcf_carry_spear, 385 , weight(2.25)|difficulty(0)|spd_rtng(89) | weapon_length(185)|swing_damage(20 , blunt) | thrust_damage(32 ,  pierce),imodbits_polearm ],


# SHIELDS
["wooden_shield", "Round Shield", [("saracin_shield_s",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield,  42 , weight(2)|hit_points(360)|body_armor(1)|spd_rtng(100)|shield_width(50),imodbits_shield ],
["nordic_shield", "Round Shield", [("saracin_shield_s",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield,  95 , weight(2)|hit_points(440)|body_armor(1)|spd_rtng(100)|shield_width(50),imodbits_shield ],
["fur_covered_shield",  "Fur Covered Shield", [("shield_kite_m",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  227 , weight(3.5)|hit_points(600)|body_armor(1)|spd_rtng(76)|shield_width(81),imodbits_shield ],
["steel_shield", "Round Shield", [("saracin_shield_s",0)], itp_type_shield, itcf_carry_round_shield,  697 , weight(4)|hit_points(700)|body_armor(17)|spd_rtng(61)|shield_width(40),imodbits_shield ],
["plate_covered_round_shield", "Round Shield", [("saracin_shield_s",0)], itp_type_shield, itcf_carry_round_shield,  140 , weight(4)|hit_points(330)|body_armor(16)|spd_rtng(90)|shield_width(40),imodbits_shield ],
["leather_covered_round_shield", "Round Shield", [("saracin_shield_s",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield,  80 , weight(2.5)|hit_points(310)|body_armor(8)|spd_rtng(96)|shield_width(40),imodbits_shield ],
["hide_covered_round_shield", "Round Shield", [("saracin_shield_s",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield,  40 , weight(2)|hit_points(260)|body_armor(3)|spd_rtng(100)|shield_width(40),imodbits_shield ],


["norman_shield_1", "Kite Shield", [("norman_shield_1",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|shield_width(90),imodbits_shield ],
["norman_shield_2", "Kite Shield", [("norman_shield_2",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|shield_width(90),imodbits_shield ],
["norman_shield_3", "Kite Shield", [("norman_shield_3",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|shield_width(90),imodbits_shield ],
["norman_shield_4", "Kite Shield", [("norman_shield_4",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|shield_width(90),imodbits_shield ],
["norman_shield_5", "Kite Shield", [("norman_shield_5",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|shield_width(90),imodbits_shield ],
["norman_shield_6", "Kite Shield", [("norman_shield_6",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|shield_width(90),imodbits_shield ],
["norman_shield_7", "Kite Shield", [("norman_shield_7",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|shield_width(90),imodbits_shield ],
["norman_shield_8", "Kite Shield", [("norman_shield_8",0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|shield_width(90),imodbits_shield ],

["tab_shield_round_a", "Old Round Shield", [("tableau_shield_round_5",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 26, weight(2.5)|hit_points(195)|body_armor(4)|spd_rtng(93)|shield_width(50),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_round_shield_5", ":agent_no", ":troop_no")])]],
["tab_shield_round_b", "Plain Round Shield", [("tableau_shield_round_3",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 65, weight(3)|hit_points(260)|body_armor(8)|spd_rtng(90)|shield_width(50),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_round_shield_3", ":agent_no", ":troop_no")])]],
["tab_shield_round_c", "Round Shield", [("tableau_shield_round_2",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(12)|spd_rtng(87)|shield_width(50),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner","tableau_round_shield_2", ":agent_no", ":troop_no")])]],
["tab_shield_round_d", "Heavy Round Shield", [("tableau_shield_round_1",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 210, weight(4)|hit_points(350)|body_armor(15)|spd_rtng(84)|shield_width(50),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_round_shield_1", ":agent_no", ":troop_no")])]],
["tab_shield_round_e", "Huscarl's Round Shield", [("tableau_shield_round_4",0)], itp_type_shield, itcf_carry_round_shield, 430, weight(4.5)|hit_points(410)|body_armor(19)|spd_rtng(81)|shield_width(50),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_round_shield_4", ":agent_no", ":troop_no")])]],

["tab_shield_kite_a", "Old Kite Shield",   [("tableau_shield_kite_1" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 33, weight(2)|hit_points(165)|body_armor(5)|spd_rtng(96)|shield_width(36)|shield_height(70),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_kite_shield_1", ":agent_no", ":troop_no")])]],
["tab_shield_kite_b", "Plain Kite Shield",   [("tableau_shield_kite_3" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 70, weight(2.5)|hit_points(215)|body_armor(10)|spd_rtng(93)|shield_width(36)|shield_height(70),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_kite_shield_3", ":agent_no", ":troop_no")])]],
["tab_shield_kite_c", "Kite Shield",   [("tableau_shield_kite_2" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_kite_shield_2", ":agent_no", ":troop_no")])]],
["tab_shield_kite_d", "Heavy Kite Shield",   [("tableau_shield_kite_2" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 320, weight(3.5)|hit_points(310)|body_armor(18)|spd_rtng(87)|shield_width(36)|shield_height(70),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_kite_shield_2", ":agent_no", ":troop_no")])]],
["tab_shield_kite_cav_a", "Horseman's Kite Shield",   [("tableau_shield_kite_4" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 205, weight(2)|hit_points(165)|body_armor(14)|spd_rtng(103)|shield_width(30)|shield_height(50),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_kite_shield_4", ":agent_no", ":troop_no")])]],
["tab_shield_kite_cav_b", "Knightly Kite Shield",   [("tableau_shield_kite_4" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 360, weight(2.5)|hit_points(225)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_kite_shield_4", ":agent_no", ":troop_no")])]],

["tab_shield_heater_a", "Old Heater Shield",   [("tableau_shield_heater_1" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 36, weight(2)|hit_points(160)|body_armor(6)|spd_rtng(96)|shield_width(36)|shield_height(70),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heater_shield_1", ":agent_no", ":troop_no")])]],
["tab_shield_heater_b", "Plain Heater Shield",   [("tableau_shield_heater_1" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 74, weight(2.5)|hit_points(210)|body_armor(11)|spd_rtng(93)|shield_width(36)|shield_height(70),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heater_shield_1", ":agent_no", ":troop_no")])]],
["tab_shield_heater_c", "Heater Shield",   [("tableau_shield_heater_1" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 160, weight(3)|hit_points(260)|body_armor(14)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heater_shield_1", ":agent_no", ":troop_no")])]],
["tab_shield_heater_d", "Heavy Heater Shield",   [("tableau_shield_heater_1" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 332, weight(3.5)|hit_points(305)|body_armor(19)|spd_rtng(87)|shield_width(36)|shield_height(70),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heater_shield_1", ":agent_no", ":troop_no")])]],
["tab_shield_heater_cav_a", "Horseman's Heater Shield",   [("tableau_shield_heater_2" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 229, weight(2)|hit_points(160)|body_armor(16)|spd_rtng(103)|shield_width(30)|shield_height(50),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heater_shield_2", ":agent_no", ":troop_no")])]],
["tab_shield_heater_cav_b", "Knightly Heater Shield",   [("tableau_shield_heater_2" ,0)], itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heater_shield_2", ":agent_no", ":troop_no")])]],

["tab_shield_pavise_a", "Old Board Shield",   [("tableau_shield_pavise_2" ,0)], itp_type_shield|itp_cant_use_on_horseback|itp_wooden_parry, itcf_carry_board_shield, 60, weight(3.5)|hit_points(280)|body_armor(4)|spd_rtng(89)|shield_width(43)|shield_height(100),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_pavise_shield_2", ":agent_no", ":troop_no")])]],
["tab_shield_pavise_b", "Plain Board Shield",   [("tableau_shield_pavise_2" ,0)], itp_type_shield|itp_cant_use_on_horseback|itp_wooden_parry, itcf_carry_board_shield, 114, weight(4)|hit_points(360)|body_armor(8)|spd_rtng(85)|shield_width(43)|shield_height(100),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_pavise_shield_2", ":agent_no", ":troop_no")])]],
["tab_shield_pavise_c", "Board Shield",   [("tableau_shield_pavise_1" ,0)], itp_type_shield|itp_cant_use_on_horseback|itp_wooden_parry, itcf_carry_board_shield, 210, weight(4.5)|hit_points(430)|body_armor(10)|spd_rtng(81)|shield_width(43)|shield_height(100),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_pavise_shield_1", ":agent_no", ":troop_no")])]],
["tab_shield_pavise_d", "Heavy Board Shield",   [("tableau_shield_pavise_1" ,0)], itp_type_shield|itp_cant_use_on_horseback|itp_wooden_parry, itcf_carry_board_shield, 370, weight(5)|hit_points(550)|body_armor(14)|spd_rtng(78)|shield_width(43)|shield_height(100),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_pavise_shield_1", ":agent_no", ":troop_no")])]],
["pavise", "Deployable Pavise",   [("pavise_wep" ,0)], itp_type_shield|itp_cant_use_on_horseback|itp_wooden_parry, itcf_carry_board_shield, 450 , weight(6.6)|hit_points(660)|body_armor(16)|spd_rtng(60)|shield_width(57)|shield_height(132),imodbits_shield ], ## Deployable Pavise
## CC
# A Tower shield? Why didn't I know anything about that?
["tab_shield_pavise_e", "Tower Shield",   [("tableau_shield_pavise_3_new" ,0)], itp_type_shield|itp_cant_use_on_horseback|itp_wooden_parry, itcf_carry_board_shield,  
470 , weight(6)|hit_points(500)|body_armor(18)|spd_rtng(78)|shield_width(43)|shield_height(90),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_pavise_shield_3", ":agent_no", ":troop_no")])]],
## CC

["tab_shield_small_round_a", "Plain Cavalry Shield", [("tableau_shield_small_round_3",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 96, weight(2)|hit_points(160)|body_armor(8)|spd_rtng(105)|shield_width(40),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_small_round_shield_3", ":agent_no", ":troop_no")])]],
["tab_shield_small_round_b", "Round Cavalry Shield", [("tableau_shield_small_round_1",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 195, weight(2.5)|hit_points(200)|body_armor(14)|spd_rtng(103)|shield_width(40),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_small_round_shield_1", ":agent_no", ":troop_no")])]],
["tab_shield_small_round_c", "Elite Cavalry Shield", [("tableau_shield_small_round_2",0)], itp_type_shield, itcf_carry_round_shield, 370, weight(3)|hit_points(250)|body_armor(22)|spd_rtng(100)|shield_width(40),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_small_round_shield_2", ":agent_no", ":troop_no")])]],

["tab_shield_small_round_a", "Plain Cavalry Shield", [("tableau_shield_small_round_3",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield,  
96 , weight(2)|hit_points(160)|body_armor(8)|spd_rtng(105)|shield_width(40),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_small_round_shield_3", ":agent_no", ":troop_no")])]],
["tab_shield_small_round_b", "Round Cavalry Shield", [("tableau_shield_small_round_1",0)], itp_type_shield|itp_wooden_parry, itcf_carry_round_shield,  
195 , weight(2.5)|hit_points(200)|body_armor(14)|spd_rtng(103)|shield_width(40),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_small_round_shield_1", ":agent_no", ":troop_no")])]],
["tab_shield_small_round_c", "Elite Cavalry Shield", [("tableau_shield_small_round_2",0)], itp_type_shield, itcf_carry_round_shield,  
370 , weight(3)|hit_points(250)|body_armor(22)|spd_rtng(100)|shield_width(40),imodbits_shield,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_small_round_shield_2", ":agent_no", ":troop_no")])]],


# RANGED
## Stones
["stones",         "Stones", [("throwing_stone",0)], itp_type_thrown |itp_primary ,itcf_throw_stone, 1 , weight(4)|difficulty(0)|spd_rtng(97) | shoot_speed(30) | thrust_damage(11 ,  blunt)|max_ammo(18)|weapon_length(8),imodbit_large_bag,missile_distance_trigger],

## Darts
["darts",         "Darts", [("dart_b",0),("dart_b_bag", ixmesh_carry)], itp_type_thrown |itp_primary ,itcf_throw_javelin|itcf_carry_quiver_right_vertical|itcf_show_holster_when_drawn, 155 , weight(4)|difficulty(1)|spd_rtng(95) | shoot_speed(28) | thrust_damage(22 ,  pierce)|max_ammo(7)|weapon_length(32),imodbits_thrown,missile_distance_trigger],
["war_darts",         "War Darts", [("dart_a",0),("dart_a_bag", ixmesh_carry)], itp_type_thrown |itp_primary ,itcf_throw_javelin|itcf_carry_quiver_back|itcf_show_holster_when_drawn, 285 , weight(5)|difficulty(1)|spd_rtng(93) | shoot_speed(27) | thrust_damage(25 ,  pierce)|max_ammo(7)|weapon_length(45),imodbits_thrown,missile_distance_trigger],

## Throwing Daggers
["throwing_knives", "Throwing Knives", [("throwing_knife",0)], itp_type_thrown |itp_primary ,itcf_throw_knife, 76 , weight(2.5)|difficulty(0)|spd_rtng(121) | shoot_speed(25) | thrust_damage(19 ,  cut)|max_ammo(14)|weapon_length(0),imodbits_thrown,missile_distance_trigger],
["throwing_daggers", "Throwing Daggers", [("throwing_dagger",0)], itp_type_thrown |itp_primary ,itcf_throw_knife, 193 , weight(2.5)|difficulty(0)|spd_rtng(110) | shoot_speed(24) | thrust_damage(25 ,  cut)|max_ammo(13)|weapon_length(0),imodbits_thrown,missile_distance_trigger],

## Throwing Spears
["javelin",         "Javelins", [("jarid_new_b",0),("jarid_new_b_bag", ixmesh_carry)], itp_type_thrown |itp_primary|itp_next_item_as_melee ,itcf_throw_javelin|itcf_carry_quiver_back|itcf_show_holster_when_drawn, 300, weight(4)|difficulty(1)|spd_rtng(91) | shoot_speed(25) | thrust_damage(34 ,  pierce)|max_ammo(5)|weapon_length(75),imodbits_thrown,missile_distance_trigger],
["javelin_melee",         "Javelin", [("jarid_new_b",0)], itp_type_polearm|itp_primary|itp_wooden_parry , itc_staff, 300, weight(1)|difficulty(0)|spd_rtng(95) |swing_damage(12, cut)| thrust_damage(14,  pierce)|weapon_length(75),imodbits_polearm ],
["throwing_spears",         "Throwing Spears", [("jarid_new_b",0),("jarid_new_b_bag", ixmesh_carry)], itp_type_thrown |itp_primary|itp_next_item_as_melee ,itcf_throw_javelin|itcf_carry_quiver_back|itcf_show_holster_when_drawn, 525 , weight(3)|difficulty(2)|spd_rtng(87) | shoot_speed(22) | thrust_damage(44 ,  pierce)|max_ammo(4)|weapon_length(65),imodbits_thrown,missile_distance_trigger],
["throwing_spear_melee",         "Throwing Spear", [("jarid_new_b",0),("jarid_new_b_bag", ixmesh_carry)],itp_type_polearm|itp_primary|itp_wooden_parry , itc_staff, 525 , weight(1)|difficulty(1)|spd_rtng(91) | swing_damage(18, cut) | thrust_damage(23 ,  pierce)|weapon_length(75),imodbits_thrown ],
["jarid",         "Jarids", [("jarid_new_b",0),("jarid_new_b_bag", ixmesh_carry)], itp_type_thrown |itp_primary|itp_next_item_as_melee ,itcf_throw_javelin|itcf_carry_quiver_back|itcf_show_holster_when_drawn, 560 , weight(2.75)|difficulty(2)|spd_rtng(89) | shoot_speed(24) | thrust_damage(45 ,  pierce)|max_ammo(4)|weapon_length(65),imodbits_thrown,missile_distance_trigger],
["jarid_melee",         "Jarid", [("jarid_new_b",0),("jarid_new_b_bag", ixmesh_carry)], itp_type_polearm|itp_primary|itp_wooden_parry , itc_staff,560 , weight(1)|difficulty(2)|spd_rtng(93) | swing_damage(16, cut) | thrust_damage(20 ,  pierce)|weapon_length(65),imodbits_thrown ],

## Throwing Axes
["light_throwing_axes", "Light Throwing Axes", [("throwing_axe_a",0)], itp_type_thrown |itp_primary|itp_next_item_as_melee,itcf_throw_axe,360, weight(5)|difficulty(2)|spd_rtng(99) | shoot_speed(18) | thrust_damage(35,cut)|max_ammo(4)|weapon_length(53),imodbits_thrown_minus_heavy,missile_distance_trigger],
["light_throwing_axes_melee", "Light Throwing Axe", [("throwing_axe_a",0)], itp_type_one_handed_wpn |itp_primary|itp_bonus_against_shield,itc_scimitar,360, weight(1)|difficulty(2)|spd_rtng(99)|weapon_length(53)| swing_damage(26,cut),imodbits_thrown_minus_heavy ],
["throwing_axes", "Throwing Axes", [("throwing_axe_a",0)], itp_type_thrown |itp_primary|itp_next_item_as_melee,itcf_throw_axe,490, weight(5)|difficulty(3)|spd_rtng(98) | shoot_speed(18) | thrust_damage(39,cut)|max_ammo(4)|weapon_length(53),imodbits_thrown_minus_heavy,missile_distance_trigger],
["throwing_axes_melee", "Throwing Axe", [("throwing_axe_a",0)], itp_type_one_handed_wpn |itp_primary|itp_bonus_against_shield,itc_scimitar,490, weight(1)|difficulty(3)|spd_rtng(98) | swing_damage(29,cut)|weapon_length(53),imodbits_thrown_minus_heavy ],
["heavy_throwing_axes", "Heavy Throwing Axes", [("throwing_axe_b",0)], itp_type_thrown |itp_primary|itp_next_item_as_melee,itcf_throw_axe,620, weight(5)|difficulty(4)|spd_rtng(97) | shoot_speed(18) | thrust_damage(44,cut)|max_ammo(4)|weapon_length(53),imodbits_thrown_minus_heavy,missile_distance_trigger],
["heavy_throwing_axes_melee", "Heavy Throwing Axe", [("throwing_axe_b",0)], itp_type_one_handed_wpn |itp_primary|itp_bonus_against_shield,itc_scimitar,620, weight(1)|difficulty(4)|spd_rtng(97) | swing_damage(32,cut)|weapon_length(53),imodbits_thrown_minus_heavy ],

## Bows
## CC
["hunting_bow", "Bow", [("saracin_bow_b",0),("saracin_bow_case_b",ixmesh_carry)],itp_type_bow |itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 17 , weight(1)|difficulty(0)|spd_rtng(100) | shoot_speed(52) | thrust_damage(15 ,  pierce),imodbits_bow ],
["short_bow", "Bow", [("saracin_bow_c",0),("saracin_bow_case_c",ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 58 , weight(1)|difficulty(0)|spd_rtng(97) | shoot_speed(55) | thrust_damage(18 ,  pierce  )|accuracy(97),imodbits_bow ],
["nomad_bow", "Bow", [("saracin_bow_a",0),("saracin_bow_case_a", ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 164 , weight(1.25)|difficulty(0)|spd_rtng(94) | shoot_speed(56) | thrust_damage(20 ,  pierce)|accuracy(95),imodbits_bow ],

["long_bow", "Bow", [("saracin_bow_b",0),("saracin_bow_case_b",ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 145 , weight(1.75)|difficulty(3)|spd_rtng(79) | shoot_speed(56) | thrust_damage(22 ,  pierce)|accuracy(93),imodbits_bow ],

#["khergit_bow", "Bow", [("khergit_bow",0),("khergit_bow_case", ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 269 , weight(1.25)|difficulty(0)|spd_rtng(90) | shoot_speed(58) | thrust_damage(25 ,pierce)|accuracy(94),imodbits_bow, [], [fac_kingdom_3,fac_kingdom_6] ],
#["khergit_bow1", "Bow", [("strong_bow",0),("strong_bow_case", ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 269 , weight(1.25)|difficulty(0)|spd_rtng(90) | shoot_speed(58) | thrust_damage(25 ,pierce)|accuracy(94),imodbits_bow, [], [fac_kingdom_3,fac_kingdom_6] ],
["khergit_bow", "Bow", [("saracin_bow_a",0),("saracin_bow_case_a", ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 269 , weight(1.25)|difficulty(0)|spd_rtng(90) | shoot_speed(58) | thrust_damage(25 ,pierce)|accuracy(94),imodbits_bow, [], [fac_kingdom_3,fac_kingdom_6] ],
["khergit_bow1", "Bow", [("saracin_bow_b",0),("saracin_bow_case_b", ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 269 , weight(1.25)|difficulty(0)|spd_rtng(90) | shoot_speed(58) | thrust_damage(25 ,pierce)|accuracy(94),imodbits_bow, [], [fac_kingdom_3,fac_kingdom_6] ],
["khergit_bow2", "Bow", [("saracin_bow_c",0),("saracin_bow_case_c", ixmesh_carry)], itp_type_bow |itp_merchandise|itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 269 , weight(1.25)|difficulty(0)|spd_rtng(90) | shoot_speed(58) | thrust_damage(25 ,pierce)|accuracy(94),imodbits_bow, [], [fac_kingdom_3,fac_kingdom_6] ],

["khergit_bow3", "Bow", [("saracin_bow_a",0),("saracin_bow_case_a", ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 269 , weight(1.25)|difficulty(0)|spd_rtng(90) | shoot_speed(58) | thrust_damage(25 ,pierce)|accuracy(94),imodbits_bow, [], [fac_kingdom_3,fac_kingdom_6] ],

["strong_bow", "Bow", [("saracin_bow_b",0),("saracin_bow_case_b", ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bowcase_left|itcf_show_holster_when_drawn, 437 , weight(1.25)|difficulty(3)|spd_rtng(88) | shoot_speed(58) | thrust_damage(23 ,pierce)|accuracy(92),imodbit_cracked | imodbit_bent | imodbit_masterwork ],
["war_bow", "Bow", [("saracin_bow_b",0),("saracin_bow_case_b",ixmesh_carry)],itp_type_bow|itp_primary|itp_two_handed ,itcf_shoot_bow|itcf_carry_bow_back, 728 , weight(1.5)|difficulty(4)|spd_rtng(84) | shoot_speed(59) | thrust_damage(25 ,pierce)|accuracy(90),imodbits_bow ],
## CC

## Crossbows
["hunting_crossbow", "Crossbow", [("crusaders_crossbows_b",0)], itp_type_crossbow |itp_primary|itp_two_handed ,itcf_shoot_crossbow,22 , weight(2.25)|difficulty(0)|spd_rtng(47) | shoot_speed(50) | thrust_damage(37 ,  pierce)|max_ammo(1),imodbits_crossbow, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["light_crossbow", "Crossbow", [("crusaders_crossbows_b",0)], itp_type_crossbow |itp_primary|itp_two_handed ,itcf_shoot_crossbow,67 , weight(2.5)|difficulty(0)|spd_rtng(45) | shoot_speed(59) | thrust_damage(44 ,  pierce)|max_ammo(1),imodbits_crossbow, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["crossbow", "Crossbow", [("crusaders_crossbows_c",0)], itp_type_crossbow |itp_merchandise|itp_primary|itp_two_handed|itp_cant_reload_on_horseback ,itcf_shoot_crossbow,182 , weight(3)|difficulty(0)|spd_rtng(43) | shoot_speed(66) | thrust_damage(49,pierce)|max_ammo(1),imodbits_crossbow, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["crossbow1", "Crossbow", [("crusaders_crossbows_b",0)], itp_type_crossbow |itp_merchandise|itp_primary|itp_two_handed|itp_cant_reload_on_horseback ,itcf_shoot_crossbow,182 , weight(3)|difficulty(0)|spd_rtng(43) | shoot_speed(66) | thrust_damage(49,pierce)|max_ammo(1),imodbits_crossbow, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["heavy_crossbow", "Crossbow", [("crusaders_crossbows_a",0)], itp_type_crossbow |itp_primary|itp_two_handed|itp_cant_reload_on_horseback ,itcf_shoot_crossbow,349 , weight(3.5)|difficulty(9)|spd_rtng(41) | shoot_speed(68) | thrust_damage(58 ,pierce)|max_ammo(1),imodbits_crossbow ],
["sniper_crossbow", "Crossbow", [("crusaders_crossbows_a",0)], itp_type_crossbow |itp_primary|itp_two_handed|itp_cant_reload_on_horseback ,itcf_shoot_crossbow,683 , weight(3.75)|difficulty(10)|spd_rtng(37) | shoot_speed(70) | thrust_damage(63 ,pierce)|max_ammo(1),imodbits_crossbow ],

## Firearms
["flintlock_pistol", "Flintlock Pistol", [("flintlock_pistol",0)], itp_type_pistol |itp_primary ,itcf_shoot_pistol|itcf_reload_pistol, 230 , weight(1.5)|difficulty(0)|spd_rtng(38) | shoot_speed(160) | thrust_damage(45 ,pierce)|max_ammo(1)|accuracy(65),imodbits_none,
 [(ti_on_weapon_attack, [(play_sound,"snd_pistol_shot"),(position_move_x, pos1,27),(position_move_y, pos1,36),(particle_system_burst, "psys_pistol_smoke", pos1, 15)])]],


["torch",         "Torch", [("club",0)], itp_type_one_handed_wpn|itp_primary, itc_scimitar, 11 , weight(2.5)|difficulty(0)|spd_rtng(95) | weapon_length(95)|swing_damage(11 , blunt) | thrust_damage(0 ,  pierce),imodbits_none,
 [(ti_on_init_item, [(set_position_delta,0,60,0),(particle_system_add_new, "psys_torch_fire"),(particle_system_add_new, "psys_torch_smoke"),(set_current_color,150, 130, 70),(add_point_light, 10, 30),
])]],

["lyre",         "Lyre", [("lyre",0)], itp_type_shield|itp_wooden_parry|itp_civilian, itcf_carry_bow_back,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|weapon_length(90),0 ],
["lute",         "Lute", [("lute",0)], itp_type_shield|itp_wooden_parry|itp_civilian, itcf_carry_bow_back,  118 , weight(2.5)|hit_points(480)|body_armor(1)|spd_rtng(82)|weapon_length(90),0 ],


# SAMURAI GEAR
["strange_armor",  "Strange Armor", [("samurai_armor",0)], itp_type_body_armor  |itp_covers_legs ,0, 1259 , weight(18)|abundance(100)|head_armor(0)|body_armor(38)|leg_armor(19)|difficulty(7) ,imodbits_armor ],
["strange_boots",  "Strange Boots", [("samurai_boots",0)], itp_type_foot_armor | itp_attach_armature,0, 465 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(21)|difficulty(0) ,imodbits_cloth ],
["strange_helmet", "Strange Helmet", [("samurai_helmet",0)], itp_type_head_armor   ,0, 824 , weight(2)|abundance(100)|head_armor(44)|body_armor(0)|leg_armor(0)|difficulty(7) ,imodbits_armor ],
["strange_sword", "Strange Sword", [("katana",0),("katana_scabbard",ixmesh_carry)], itp_type_two_handed_wpn| itp_primary, itc_bastardsword|itcf_carry_katana|itcf_show_holster_when_drawn, 679 , weight(2.0)|difficulty(9)|spd_rtng(108) | weapon_length(95)|swing_damage(32 , cut) | thrust_damage(18 ,  pierce),imodbits_sword ],
["strange_great_sword",  "Strange Great Sword", [("no_dachi",0),("no_dachi_scabbard",ixmesh_carry)], itp_type_two_handed_wpn|itp_two_handed|itp_primary, itc_nodachi|itcf_carry_sword_back|itcf_show_holster_when_drawn, 920 , weight(3.5)|difficulty(11)|spd_rtng(92) | weapon_length(125)|swing_damage(38 , cut) | thrust_damage(0 ,  pierce),imodbits_axe ],
["strange_short_sword", "Strange Short Sword", [("wakizashi",0),("wakizashi_scabbard",ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_wakizashi|itcf_show_holster_when_drawn, 321 , weight(1.25)|difficulty(0)|spd_rtng(108) | weapon_length(65)|swing_damage(25 , cut) | thrust_damage(19 ,  pierce),imodbits_sword ],


["court_dress", "Court Dress", [("lady_dress_r",0)], itp_type_body_armor|itp_covers_legs|itp_civilian, 0, 348, weight(4)|abundance(100)|head_armor(0)|body_armor(14)|leg_armor(4)|difficulty(0) ,imodbits_cloth ],
["rich_outfit", "Rich Outfit", [("noble4",0)], itp_type_body_armor|itp_covers_legs|itp_civilian, 0, 348, weight(4)|abundance(100)|head_armor(0)|body_armor(16)|leg_armor(4)|difficulty(0) ,imodbits_cloth ],
["khergit_guard_armor", "Armor", [("armor_medium_tyrk_c",0)], itp_type_body_armor|itp_covers_legs, 0, 3048, weight(25)|abundance(100)|head_armor(0)|body_armor(50)|leg_armor(18)|difficulty(0) ,imodbits_armor ],

["felt_steppe_cap", "Turban", [("beduin_turban_a",0)], itp_type_head_armor | itp_fit_to_head | itp_attach_armature  ,0, 237 , weight(2)|abundance(100)|head_armor(16)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["khergit_helmet", "Helmet", [("gulam_helm_c",0)], itp_type_head_armor  | itp_fit_to_head | itp_attach_armature ,0, 361 , weight(2)|abundance(70)|head_armor(33)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["khergit_guard_boots",  "Boots", [("saracin_hard_boot_a",0)], itp_type_foot_armor | itp_attach_armature,0, 254 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(20)|difficulty(0) ,imodbits_cloth ],

["mail_and_plate", "Armor", [("dethertir_armor_e",0)], itp_type_body_armor|itp_covers_legs   ,0, 593 , weight(16)|abundance(50)|head_armor(0)|body_armor(34)|leg_armor(12)|difficulty(0) ,imodbits_armor ],
["light_mail_and_plate", "Armor", [("dethertir_armor_e",0)], itp_type_body_armor|itp_covers_legs   ,0, 532 , weight(10)|abundance(50)|head_armor(0)|body_armor(32)|leg_armor(12)|difficulty(0) ,imodbits_armor ],

["byzantion_helmet_a", "Helmet", [("dethertir_helm_b",0)], itp_type_head_armor   ,0, 278 , weight(2)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["magyar_helmet_a", "Helmet", [("dethertir_helm_b",0)], itp_type_head_armor   ,0, 278 , weight(2)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
# ["rus_helmet_a", "Rus Helmet", [("rus_helmet_a",0)], itp_type_head_armor   ,0, 278 , weight(2)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["sipahi_helmet_a", "Helmet", [("dethertir_helm_b",0)], itp_type_head_armor   ,0, 278 , weight(2)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
["shahi", "Helmet", [("dethertir_helm_b",0)], itp_type_head_armor   ,0, 278 , weight(2)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],
# ["rabati", "Rabati", [("rabati",0)], itp_type_head_armor   ,0, 278 , weight(2)|abundance(100)|head_armor(20)|body_armor(0)|leg_armor(0) ,imodbits_cloth ],

["keys", "Ring of Keys", [("throwing_axe_a",0)], itp_type_one_handed_wpn |itp_primary|itp_bonus_against_shield,itc_scimitar,240, weight(5)|spd_rtng(98) | swing_damage(29,cut)|max_ammo(5)|weapon_length(53),imodbits_thrown ],
["bride_dress", "Bride Dress", [("bride_dress",0)], itp_type_body_armor  |itp_covers_legs|itp_civilian ,0, 500 , weight(3)|abundance(100)|head_armor(0)|body_armor(10)|leg_armor(10)|difficulty(0) ,imodbits_cloth],
["bride_crown", "Crown of Flowers", [("bride_crown",0)],  itp_type_head_armor | itp_doesnt_cover_hair |itp_civilian |itp_attach_armature,0, 1 , weight(0.5)|abundance(100)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth ],
["bride_shoes", "Bride Shoes", [("bride_shoes",0)], itp_type_foot_armor |itp_civilian | itp_attach_armature ,0, 30 , weight(1)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(8)|difficulty(0) ,imodbits_cloth ],

["practice_bow_2","Practice Bow", [("saracin_bow_b",0), ("saracin_bow_case_b",ixmesh_carry)], itp_type_bow |itp_primary|itp_two_handed,itcf_shoot_bow|itcf_carry_bowcase_left, 0, weight(1.5)|spd_rtng(90) | shoot_speed(40) | thrust_damage(21, blunt),imodbits_bow ],
["practice_arrows_2","Practice Arrows", [("arrow_tyrk_a",0),("flying_arrow",ixmesh_flying_ammo),("kolchan_tyrk_a", ixmesh_carry)], itp_type_arrows, itcf_carry_quiver_back, 0,weight(1.5)|weapon_length(95)|max_ammo(80),imodbits_missile],

["heraldic_mail_with_surcoat_for_tableau", "Heraldic Mail with Surcoat", [("heraldic_armor_new_a",0)], itp_type_body_armor |itp_covers_legs ,0, 1, weight(22)|abundance(100)|head_armor(0)|body_armor(1)|leg_armor(1),imodbits_armor,
 [(ti_on_init_item, [(store_trigger_param_1, ":agent_no"),(store_trigger_param_2, ":troop_no"),(call_script, "script_shield_item_set_banner", "tableau_heraldic_armor_a", ":agent_no", ":troop_no")])]],
["mail_boots_for_tableau", "Mail Boots", [("mail_boots_a",0)], itp_type_foot_armor | itp_attach_armature  ,0, 1, weight(3)|abundance(100)|head_armor(0)|body_armor(0)|leg_armor(1) ,imodbits_armor ],


##diplomacy begin
["dplmc_coat_of_plates_red_constable", "Rich Outfit", [("noble6",0)], itp_unique|itp_type_body_armor|itp_covers_legs|itp_civilian,0,
 3828 , weight(25)|abundance(100)|head_armor(0)|body_armor(52)|leg_armor(16)|difficulty(0) ,imodbits_armor, [], []],
##diplomacy end





#Sands of Faith Items



 #hispania 1200 taverna Daedalus / Slawomir of Aaarrghh
["dedal_kufel","Kufel",[("dedal_kufelL",0)],	itp_type_hand_armor,0,0,weight(1),0],
["dedal_lutnia","Lutnia",[("dedal_lutniaL",0)],	itp_type_hand_armor,0,0,weight(1),0],
["dedal_lira","Lira",[("dedal_liraL",0)],		itp_type_hand_armor,0,0,weight(1),0],
 #fin hispania 1200 taverna Daedalus / Slawomir of Aaarrghh

#Vendors

["village_robe", "Village Robe", [("civil1",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["village_robe1", "Village Robe", [("civil2",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["village_robe2", "Village Robe", [("civil3",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["village_robe3", "Village Robe", [("civil4",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["village_robe4", "Village Robe", [("civil5",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["village_robe5", "Village Robe", [("civil6",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],
["village_robe6", "Village Robe", [("civil7",0)],  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(100)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth ],

#Religious Leaders

["priest_tem", "Tunic", [("monie_templar_a",0)],  itp_unique|  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(0)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["priest_hos", "Tunic", [("monie_hospitaller_b",0)],  itp_unique|  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(0)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["bishop_tem", "Tunic", [("bishop_templar",0)],  itp_unique|  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(0)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["bishop_hos", "Tunic", [("bishop_hospitaller",0)],  itp_unique|  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(0)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["archbishop_tem", "Tunic", [("archbishop_templar",0)],  itp_unique|  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(0)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["archbishop_hos", "Tunic", [("archbishop_hospitaller",0)],  itp_unique|  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(0)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["mufti_tunic", "Tunic", [("caravan_armor_a",0)],  itp_unique|  itp_type_body_armor  |itp_covers_legs ,0, 33 , weight(1)|abundance(0)|head_armor(0)|body_armor(9)|leg_armor(9)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],

["priest_coif_tem", "Coif", [("koif_monie_b",0)], itp_unique| itp_type_head_armor | itp_fit_to_head   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["priest_coif_hos", "Coif", [("koif_monie_a",0)], itp_unique| itp_type_head_armor | itp_fit_to_head   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["bishop_coif_tem", "Coif", [("bishop_koif_a",0)], itp_unique| itp_type_head_armor | itp_fit_to_head   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["bishop_coif_hos", "Coif", [("bishop_koif_b",0)], itp_unique| itp_type_head_armor | itp_fit_to_head   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["archbishop_coif_tem", "Coif", [("Mithras_archbishop_templar",0)], itp_unique| itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["archbishop_coif_hos", "Coif", [("Mithras_archbishop_hospitaller",0)], itp_unique| itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["religious_boots", "Boots", [("civil_rich_Boots_a",0)], itp_unique| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["mufti_turban", "Turban", [("beduin_turban_a",0)], itp_unique| itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0, 700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],

#Christian Armors

["priest_tunic", "Templar Priest Tunic", [("bishop_templar",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(0)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_4]],
["bishop_tunic", "Templar Bishop Tunic", [("archbishop_templar",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(0)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_4]],

["priest_tunic1", "Hospitaller Priest Tunic", [("bishop_hospitaller",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(0)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_2,fac_kingdom_5]],
["bishop_tunic1", "Hospitaller Bishop Tunic", [("archbishop_hospitaller",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(0)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_2,fac_kingdom_5]],

["priest_tunic2", "Teutonic Priest Tunic", [("bishop_tevton",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(0)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["bishop_tunic2", "Teutonic Bishop Tunic", [("archbishop_tevton",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(0)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["battle_tunic", "Battlefield Mufti Tunic", [("caravan_armor_a",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(0)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],

["priest_coif", "Templar Priest Coif", [("bishop_koif_a",0)], itp_unique| itp_type_head_armor | itp_fit_to_head   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_4] ],
["bishop_coif", "Templar Bishop Coif", [("Mithras_archbishop_templar",0)], itp_unique| itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_4] ],

["priest_coif1", "Hospitaller Priest Coif", [("bishop_koif_b",0)], itp_unique| itp_type_head_armor | itp_fit_to_head   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2,fac_kingdom_5] ],
["bishop_coif1", "Hospitaller Bishop Coif", [("Mithras_archbishop_hospitaller",0)], itp_unique| itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2,fac_kingdom_5] ],

["priest_coif2", "Teutonic Priest Coif", [("bishop_koif_c",0)], itp_unique| itp_type_head_armor | itp_fit_to_head   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["bishop_coif2", "Teutonic Bishop Coif", [("Mithras_archbishop_tevton",0)], itp_unique| itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["battle_turban", "Battlefield Mufti Turban", [("beduin_turban_a",0)], itp_unique| itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0,  700 , weight(1.15)|abundance(0)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],

["priest_boots", "Battlefield Priest Boots", [("civil_rich_Boots_a",0)], itp_unique| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 75 , weight(1)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["priest_boots1", "Battlefield Priest Boots", [("civil_rich_Boots_b",0)], itp_unique| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 75 , weight(1)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["battle_boots", "Battlefield Mufti Boots", [("saracin_light_boot_a",0)], itp_unique| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 75 , weight(1)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_3,fac_kingdom_6]],

["novici_jer", "Jerusalem Tunic", [("novici_Jerusalem",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1]],
["novici_ibe", "Jerusalem Tunic", [("novici_ibelin",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1]],

["novici_ant", "Antioch Tunic", [("novici_antioh_armor",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_2]],
["novici_tri", "Antioch Tunic", [("novici_tripoli_armor",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_2]],

["novici_tem", "Templar Tunic", [("novici_templar",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_4]],

["novici_hos", "Hospitaller Tunic", [("novici_hospitaller",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_5]],

["novici_teu", "Teutonic Tunic", [("novici_tevton",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2]],

["infantry_jer1", "Jerusalem Infantry Tunic", [("armor_infantry_Jerusalem_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],
["infantry_jer2", "Jerusalem Infantry Tunic", [("armor_infantry_Jerusalem_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],
["infantry_ibe1", "Jerusalem Infantry Tunic", [("armor_infantry_ibelin_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],
["infantry_ibe2", "Jerusalem Infantry Tunic", [("armor_infantry_ibelin_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],

["infantry_ant1", "Antioch Infantry Tunic", [("armor_infantry_antioh_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],
["infantry_ant2", "Antioch Infantry Tunic", [("armor_infantry_antioh_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],
["infantry_tri1", "Antioch Infantry Tunic", [("armor_infantry_tripoli_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],
["infantry_tri2", "Antioch Infantry Tunic", [("armor_infantry_tripoli_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],

["infantry_tem1", "Templar Infantry Tunic", [("armor_infantry_templar_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],
["infantry_tem2", "Templar Infantry Tunic", [("armor_infantry_templar_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],

["infantry_hos1", "Hospitaller Infantry Tunic", [("armor_infantry_hospitaller_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],
["infantry_hos2", "Hospitaller Infantry Tunic", [("armor_infantry_hospitaller_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],

["infantry_teu1", "Teutonic Infantry Tunic", [("armor_infantry_tevton_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],
["infantry_teu2", "Teutonic Infantry Tunic", [("armor_infantry_tevton_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],

["archer_jer1", "Jerusalem Crossbowman Tunic", [("archer_jerusalem_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],
["archer_jer2", "Jerusalem Crossbowman Tunic", [("archer_jerusalem_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],
["archer_ibe1", "Jerusalem Crossbowman Tunic", [("archer_ibelin_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],
["archer_ibe2", "Jerusalem Crossbowman Tunic", [("archer_ibelin_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],

["archer_ant1", "Antioch Crossbowman Tunic", [("archer_antioh_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],
["archer_ant2", "Antioch Crossbowman Tunic", [("archer_antioh_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],
["archer_tri1", "Antioch Crossbowman Tunic", [("archer_tripoli_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],
["archer_tri2", "Antioch Crossbowman Tunic", [("archer_tripoli_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],

["archer_tem1", "Templar Crossbowman Tunic", [("archer_templar_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],
["archer_tem2", "Templar Crossbowman Tunic", [("archer_templar_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],

["archer_hos1", "Hospitaller Crossbowman Tunic", [("archer_hospitaller_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],
["archer_hos2", "Hospitaller Crossbowman Tunic", [("archer_hospitaller_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],

["archer_teu1", "Teutonic Crossbowman Tunic", [("archer_tevton_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],
["archer_teu2", "Teutonic Crossbowman Tunic", [("archer_tevton_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],

["sergeant_jer1", "Jerusalem Sergeant Mail", [("sergeant_Jerusalem_armor",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],   
["sergeant_ibe1", "Jerusalem Sergeant Mail", [("sergeant_ibelin_armor",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],   

["sergeant_ant1", "Antioch Sergeant Mail", [("sergeant_armor_antioh_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],   
["sergeant_ant2", "Antioch Sergeant Mail", [("sergeant_armor_antioh_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],   
["sergeant_tri1", "Antioch Sergeant Mail", [("sergeant_armor_tripoli_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]],   
["sergeant_tri2", "Antioch Sergeant Mail", [("sergeant_armor_tripoli_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 

["sergeant_temp1", "Templar Sergeant Mail", [("sergeant_templar_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],   
["sergeant_temp2", "Templar Sergeant Mail", [("sergeant_templar_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],  
["sergeant_temp3", "Templar Monk Mail", [("armor_monie_templar_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],   
["sergeant_temp4", "Templar Monk Mail", [("armor_monie_templar_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],      

["sergeant_hos1", "Hospitaller Sergeant Mail", [("sergeant_hospitaller_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],   
["sergeant_hos2", "Hospitaller Sergeant Mail", [("sergeant_hospitaller_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],  
["sergeant_hos3", "Hospitaller Monk Mail", [("armor_monie_hospitaller_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],   
["sergeant_hos4", "Hospitaller Monk Mail", [("armor_monie_hospitaller_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],      

["sergeant_teu1", "Teutonic Sergeant Mail", [("sergeant_tevton_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],   
["sergeant_teu2", "Teutonic Sergeant Mail", [("sergeant_tevton_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],  
["sergeant_teu3", "Teutonic Monk Mail", [("armor_monie_tevton_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],   
["sergeant_teu4", "Teutonic Monk Mail", [("armor_monie_tevton_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(15)|head_armor(0)|body_armor(29)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],      

["knight_jer1", "Jerusalem Knight Mail", [("knight_armor_jerusalem_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_jer2", "Jerusalem Knight Mail", [("knight_armor_jerusalem_a_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_jer3", "Jerusalem Knight Mail", [("knight_armor_jerusalem_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_jer4", "Jerusalem Knight Mail", [("knight_armor_jerusalem_b_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_jer5", "Jerusalem Knight Mail", [("knight_armor_jerusalem_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_jer6", "Jerusalem Knight Mail", [("knight_armor_jerusalem_c_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_jer7", "Jerusalem Knight Mail", [("knight_armor_jerusalem_d_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_jer8", "Jerusalem Knight Mail", [("knight_armor_jerusalem_e_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_jer9", "Jerusalem Knight Mail", [("knight_armor_jerusalem_f_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 

["knight_ibe1", "Jerusalem Knight Mail", [("knight_armor_ibelin_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_ibe2", "Jerusalem Knight Mail", [("knight_armor_ibelin_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_ibe3", "Jerusalem Knight Mail", [("knight_armor_ibelin_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_ibe4", "Jerusalem Knight Mail", [("knight_armor_ibelin_a_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_ibe5", "Jerusalem Knight Mail", [("knight_armor_ibelin_b_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["knight_ibe6", "Jerusalem Knight Mail", [("knight_armor_ibelin_c_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 

["knight_ant1", "Antioch Knight Mail", [("knight_armor_antioh_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_ant2", "Antioch Knight Mail", [("knight_armor_antioh_a_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_ant3", "Antioch Knight Mail", [("knight_armor_antioh_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_ant4", "Antioch Knight Mail", [("knight_armor_antioh_b_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_ant5", "Antioch Knight Mail", [("knight_armor_antioh_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_ant6", "Antioch Knight Mail", [("knight_armor_antioh_c_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_ant7", "Antioch Knight Mail", [("knight_armor_antioh_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_ant8", "Antioch Knight Mail", [("knight_armor_antioh_d_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_ant9", "Antioch Knight Mail", [("knight_armor_antioh_e",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_ant10", "Antioch Knight Mail", [("knight_armor_antioh_e_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 

["knight_tri1", "Antioch Knight Mail", [("knight_armor_tripolli_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_tri2", "Antioch Knight Mail", [("knight_armor_tripolli_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_tri3", "Antioch Knight Mail", [("knight_armor_tripolli_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_tri4", "Antioch Knight Mail", [("knight_armor_tripolli_a_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_tri5", "Antioch Knight Mail", [("knight_armor_tripolli_b_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 
["knight_tri6", "Antioch Knight Mail", [("knight_armor_tripolli_c_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_2]], 

["knight_tem1", "Templar Knight Mail", [("knight_armor_templar_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem2", "Templar Knight Mail", [("knight_armor_templar_a_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem3", "Templar Knight Mail", [("knight_armor_templar_a_1_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem4", "Templar Knight Mail", [("knight_armor_templar_a_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem5", "Templar Knight Mail", [("knight_armor_templar_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem6", "Templar Knight Mail", [("knight_armor_templar_c_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem7", "Templar Knight Mail", [("knight_armor_templar_f",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem8", "Templar Knight Mail", [("knight_armor_templar_f_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 

["knight_tem_conf1", "Templar Knight Mail", [("knight_armor_templar_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem_conf2", "Templar Knight Mail", [("knight_armor_templar_b_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem_conf3", "Templar Knight Mail", [("knight_armor_templar_b_1_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem_conf4", "Templar Knight Mail", [("knight_armor_templar_b_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem_conf5", "Templar Knight Mail", [("knight_armor_templar_d_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem_conf6", "Templar Knight Mail", [("knight_armor_templar_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem_conf7", "Templar Knight Mail", [("knight_armor_templar_d_1_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem_conf8", "Templar Knight Mail", [("knight_armor_templar_d_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem_conf9", "Templar Knight Mail", [("knight_armor_templar_e",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["knight_tem_conf10", "Templar Knight Mail", [("knight_armor_templar_e_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 

["monk_temp1", "Templar Monk Knight", [("armor_monie_templar_a",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],   
["monk_temp2", "Templar Monk Knight", [("armor_monie_templar_b",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],      

["knight_hos1", "Hospitaller Knight Mail", [("knight_armor_hospitaller_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos2", "Hospitaller Knight Mail", [("knight_armor_hospitaller_b_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos3", "Hospitaller Knight Mail", [("knight_armor_hospitaller_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos4", "Hospitaller Knight Mail", [("knight_armor_hospitaller_d_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos5", "Hospitaller Knight Mail", [("knight_armor_hospitaller_d_cloak_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos6", "Hospitaller Knight Mail", [("knight_armor_hospitaller_f",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos7", "Hospitaller Knight Mail", [("knight_armor_hospitaller_f_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos8", "Hospitaller Knight Mail", [("knight_armor_hospitaller_f_cloak_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 

["knight_hos_conf1", "Hospitaller Knight Mail", [("knight_armor_hospitaller_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos_conf2", "Hospitaller Knight Mail", [("knight_armor_hospitaller_a_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos_conf3", "Hospitaller Knight Mail", [("knight_armor_hospitaller_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos_conf4", "Hospitaller Knight Mail", [("knight_armor_hospitaller_c_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos_conf5", "Hospitaller Knight Mail", [("knight_armor_hospitaller_e",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["knight_hos_conf6", "Hospitaller Knight Mail", [("knight_armor_hospitaller_e_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 

["monk_hos1", "Hospitaller Monk Knight", [("armor_monie_hospitaller_a",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],   
["monk_hos2", "Hospitaller Monk Knight", [("armor_monie_hospitaller_b",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],      

["knight_teu1", "Teutonic Knight Mail", [("knight_armor_tevton_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu2", "Teutonic Knight Mail", [("knight_armor_tevton_a_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu3", "Teutonic Knight Mail", [("knight_armor_tevton_a_1_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu4", "Teutonic Knight Mail", [("knight_armor_tevton_a_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu5", "Teutonic Knight Mail", [("knight_armor_tevton_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu6", "Teutonic Knight Mail", [("knight_armor_tevton_b_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu7", "Teutonic Knight Mail", [("knight_armor_tevton_b_1_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu8", "Teutonic Knight Mail", [("knight_armor_tevton_b_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu9", "Teutonic Knight Mail", [("knight_armor_tevton_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu10", "Teutonic Knight Mail", [("knight_armor_tevton_c_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 

["knight_teu_conf1", "Teutonic Knight Mail", [("knight_armor_tevton_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu_conf2", "Teutonic Knight Mail", [("knight_armor_tevton_d_1_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 
["knight_teu_conf3", "Teutonic Knight Mail", [("knight_armor_tevton_d_cloak",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 

["securiti_jer1", "Jerusalem Guard Tunic", [("securiti_caravan_cloak_crusader",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(17)|abundance(15)|head_armor(0)|body_armor(25)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],   
["securiti_jer2", "Jerusalem Guard Tunic", [("securiti_caravan_crusader",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(17)|abundance(15)|head_armor(0)|body_armor(25)|leg_armor(12)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],   

["lord_jer", "Jerusalem King Mail", [("armor_king_Jerusalem",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 7500 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]], 
["lord_tem", "Templar Grandmaster Mail", [("armor_master_order_templar",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 7500 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]], 
["lord_hos", "Hospitaller Grandmaster Mail", [("armor_master_order_hospitaller",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 7500 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]], 
["lord_teu", "Teutonic Grandmaster Mail", [("armor_master_order_tevton",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 7500 , weight(22)|abundance(10)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]], 

["special_jer1", "Jerusalem Palace Tunic", [("securiti_caravan_cloak_crusader",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],   
["special_jer2", "Jerusalem Palace Tunic", [("securiti_caravan_crusader",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 1000 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],   

#Muslim Armors 

["tunic_sar1", "Arabian Tunic", [("arabian_light_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_sar2", "Arabian Tunic", [("arabian_light_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_sar3", "Arabian Tunic", [("arabian_light_armor_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_sar4", "Arabian Tunic", [("arabian_light_armor_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_sar5", "Arabian Tunic", [("armor_archer_saracin_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_sar6", "Arabian Tunic", [("armor_archer_saracin_2",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_sar7", "Arabian Tunic", [("armor_archer_saracin_3",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_sar8", "Arabian Tunic", [("armor_archer_saracin_4",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_sar9", "Arabian Tunic", [("armor_archer_saracin_5",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_sar10", "Arabian Tunic", [("armor_archer_saracin_6",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],

["armor_sel1", "Turk Armor", [("armor_medium_tyrk_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3]], 
["armor_sel2", "Turk Armor", [("armor_medium_tyrk_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3]], 
["armor_sel3", "Turk Armor", [("armor_medium_tyrk_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3]], 
["armor_sel4", "Turk Armor", [("armor_medium_tyrk_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3]], 
["armor_sel5", "Turk Armor", [("armor_medium_tyrk_e",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3]], 
["armor_sel6", "Turk Armor", [("armor_medium_tyrk_f",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3]], 

["armor_ayy1", "Arabian Armor", [("heavy_armor_arabs_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]], 
["armor_ayy2", "Arabian Armor", [("heavy_armor_arabs_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]], 
["armor_ayy3", "Arabian Armor", [("heavy_armor_arabs_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]], 
["armor_ayy4", "Arabian Armor", [("heavy_armor_arabs_c_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]], 
["armor_ayy5", "Arabian Armor", [("heavy_armor_arabs_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]], 
["armor_ayy6", "Arabian Armor", [("heavy_armor_arabs_e",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]], 
["armor_ayy7", "Arabian Armor", [("heavy_armor_arabs_f",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]], 
["armor_ayy8", "Arabian Armor", [("heavy_armor_arabs_f_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]], 

["mamluk_sel1", "Turk Cavalry Armor", [("tyrk_armor_heavi_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]],    
["mamluk_sel2", "Turk Cavalry Armor", [("tyrk_armor_heavi_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]],    
["mamluk_sel3", "Turk Cavalry Armor", [("tyrk_armor_heavi_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]],
   
["mamluk_ayy1", "Arabian Cavalry Armor", [("Ghulam_heavy_cavalryman_1",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]],    
["mamluk_ayy2", "Arabian Cavalry Armor", [("Ghulam_heavy_cavalryman_2",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]],    
["mamluk_ayy3", "Arabian Cavalry Armor", [("Ghulam_heavy_cavalryman_3",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(15)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]], 

["lord_sar", "Sultan Armor", [("armor_Sultan_saracens",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]], 

["palace_sar", "Palace Guard Armor", [("armor_Sultan_guards",0)], itp_unique| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(0)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6]],             

#Bandit Armors

#["tunic_beduin1", "Bedouin Tunic", [("caravan_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_beduin2", "Bedouin Tunic", [("beduin_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_beduin3", "Bedouin Tunic", [("beduin_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],
["tunic_beduin4", "Bedouin Tunic", [("beduin_armor_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3,fac_kingdom_6]],

["armor_steppe1", "Steppe Armor", [("turk_bandit_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]], 
["armor_steppe2", "Steppe Armor", [("turk_bandit_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]], 
["armor_steppe3", "Steppe Armor", [("turk_bandit_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]], 
["armor_steppe4", "Steppe Armor", [("turk_bandit_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]], 

["armor_desert1", "Desert Armor", [("arab_bandit_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]], 
["armor_desert2", "Desert Armor", [("arab_bandit_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]], 
["armor_desert3", "Desert Armor", [("arab_bandit_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]], 
["armor_desert4", "Desert Armor", [("arab_bandit_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]], 

#Mercenary Armors

["novici_mercenary1", "Tunic", [("dethertir_armor_f",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["novici_mercenary2", "Tunic", [("dethertir_armor_h",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 250 , weight(10)|abundance(50)|head_armor(0)|body_armor(22)|leg_armor(6)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["infantry_mercenary1", "Infantry Tunic", [("dethertir_armor_c",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["infantry_mercenary2", "Infantry Tunic", [("dethertir_armor_g",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 500 , weight(17)|abundance(25)|head_armor(0)|body_armor(25)|leg_armor(7)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["knight_mercenary1", "Knight Mail", [("dethertir_armor_a",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(5)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["knight_mercenary2", "Knight Mail", [("dethertir_armor_e",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(5)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["knight_mercenary3", "Knight Mail", [("dethertir_armor_b",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(5)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["knight_mercenary4", "Knight Mail", [("dethertir_armor_d",0)], itp_merchandise| itp_type_body_armor  |itp_covers_legs ,0, 5000 , weight(22)|abundance(5)|head_armor(0)|body_armor(35)|leg_armor(17)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

#Christian Helmets

["coif_black", "Coif", [("koif_monie_a",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0,  700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["coif_white", "Coif", [("koif_monie_b",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0,  700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet_lig1", "Helmet", [("light_capelina_crusader_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet_lig2", "Helmet", [("light_capelina_crusader_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet_lig3", "Helmet", [("light_crusader_helm_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet_lig4", "Helmet", [("light_crusader_helm_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet_lig5", "Helmet", [("light_crusader_helm_c",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet_lig6", "Helmet", [("light_crusader_helm_d",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet_lig7", "Helmet", [("light_crusader_helm_e",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["helmet1", "Helmet", [("capelina_crusader_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet2", "Helmet", [("capelina_crusader_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet3", "Helmet", [("crusader_helm_medium_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet4", "Helmet", [("crusader_helm_medium_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet5", "Helmet", [("crusader_helm_medium_c",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet6", "Helmet", [("crusader_helm_medium_d",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet7", "Helmet", [("crusader_helm_medium_e",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet8", "Helmet", [("marching_helmet_crusader_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["coif_infantry", "Mail Coif", [("crusader_koif_a",0)], itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["helmet_golden1", "Helmet", [("fracia_helmet_1",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet_golden2", "Helmet", [("fracia_helmet_2",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["helmet_golden3", "Helmet", [("fracia_knight_helm_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0,  950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],

["coif_knight", "Knight Coif", [("crusader_koif_a",0)], itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helmet_knight1", "Knight Helmet", [("crusader_helm_1",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helmet_knight2", "Knight Helmet", [("crusader_helm_2",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helmet_knight3", "Knight Helmet", [("crusader_helm_3",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helmet_knight4", "Knight Helmet", [("crusader_helm_4",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helmet_knight5", "Knight Helmet", [("crusader_helm_5",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helmet_knight6", "Knight Helmet", [("crusader_helm_6",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helmet_knight7", "Knight Helmet", [("crusader_helm_7",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   

["helm1", "Helm", [("crusader_hard_helm_d",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm2", "Helm", [("crusader_hard_helm_f",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   

["helm_golden1", "Helm", [("crusader_hard_helm_a",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_golden2", "Helm", [("crusader_hard_helm_b",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_golden3", "Helm", [("crusader_hard_helm_c",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   

["helm_ord", "Helm", [("crusader_hard_helm_ord",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_ord_white", "Helm", [("namet_crusader_hard_helm_ord",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_ord_black", "Helm", [("namet_hospitalier_hard_helm_1",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_ord_red", "Helm", [("namet_hospitalier_hard_helm_2",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_teu", "Teutonic Helm", [("crusader_knight_helm_a",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],   
["helm_teu1", "Teutonic Helm", [("namet_crusader_helm_a",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2]],   
["helm_tem", "Templar Helm", [("crusader_knight_helm_b",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],   
["helm_tem1", "Templar Helm", [("namet_crusader_helm_b",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4]],   
["helm_red", "Helm", [("crusader_knight_helm_c",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_red1", "Helm", [("namet_crusader_helm_c",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_black", "Helm", [("crusader_knight_helm_d",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_black1", "Helm", [("namet_crusader_helm_d",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_hos", "Hospitaller Helm", [("crusader_knight_helm_e",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],   
["helm_hos1", "Hospitaller Helm", [("namet_crusader_helm_e",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_5]],   
["helm_jer", "Jerusalem Helm", [("crusader_knight_helm_f",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],   
["helm_jer1", "Jerusalem Helm", [("namet_crusader_helm_f",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],   
["helm_jer2", "Jerusalem Helm", [("namet_crusader_helm_f_1",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],   

["securit_helmet_jer1", "Jerusalem Guard Helmet", [("securiti_crysader_helm_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard |  itp_attach_armature ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1] ], 
["securit_helmet_jer2", "Jerusalem Guard Helmet", [("securiti_crysader_helm_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard |  itp_attach_armature ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1] ], 

["mask_jer", "Baldwin Mask", [("yelushaleng",0)],  itp_unique|itp_type_head_armor|itp_fit_to_head,0, 4500 , weight(3)|abundance(0)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],  
["crown_jer", "Jerusalem Crown", [("helm_king_Jerusalem",0)],  itp_unique|itp_type_head_armor|itp_fit_to_head | itp_attach_armature,0, 4500 , weight(3)|abundance(0)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1]],  

["special_helmet_jer1", "Jerusalem Palace Helmet", [("securiti_crysader_helm_a",0)], itp_unique| itp_type_head_armor | itp_covers_beard |  itp_attach_armature ,0, 4500 , weight(3)|abundance(0)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1] ], 
["special_helmet_jer2", "Jerusalem Palace Helmet", [("securiti_crysader_helm_b",0)], itp_unique| itp_type_head_armor | itp_covers_beard |  itp_attach_armature ,0, 4500 , weight(3)|abundance(0)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1] ], 

["coif_monk", "Monk Coif", [("koif_monie_a",0)], itp_unique| itp_type_head_armor | itp_fit_to_head   ,0,  4500 , weight(3)|abundance(0)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_4,fac_kingdom_5] ],

#Muslim Helmets 

["helmet_lig_sar1", "Arabian Helmet", [("helm_saracin_1",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],
["helmet_lig_sar2", "Arabian Helmet", [("helm_saracin_3",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],
["helmet_lig_sar3", "Arabian Helmet", [("helm_saracin_b",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],
["helmet_lig_sar4", "Arabian Helmet", [("helm_saracin_c",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],
["helmet_lig_sar5", "Arabian Helmet", [("helm_saracin_d",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],
["helmet_lig_sar6", "Arabian Helmet", [("helm_saracin_e",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],
["helmet_lig_sar7", "Arabian Helmet", [("helm_saracin_f",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],

["helmet_sel1", "Turk Helmet", [("helm_tyrk_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3] ], 
["helmet_sel2", "Turk Helmet", [("helm_tyrk_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3] ], 
["helmet_sel3", "Turk Helmet", [("helm_tyrk_c",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3] ], 
["helmet_sel4", "Turk Helmet", [("helm_tyrk_d",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3] ], 
["helmet_sel5", "Turk Helmet", [("helm_tyrk_e",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3] ], 
["helmet_sel6", "Turk Helmet", [("helm_tyrk_f",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3] ], 

["helmet_ayy1", "Arabian Helmet", [("helm_saracin_2",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 
["helmet_ayy2", "Arabian Helmet", [("helm_saracin_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 
["helmet_ayy3", "Arabian Helmet", [("helm_saracin_j",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 
["helmet_ayy4", "Arabian Helmet", [("saracin_turban_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 
["helmet_ayy5", "Arabian Helmet", [("saracin_turban_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 
["helmet_ayy6", "Arabian Helmet", [("saracin_turban_c",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 950 , weight(1.25)|abundance(15)|head_armor(25)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 

["helm_sel1", "Turk Cavalry Helmet", [("helm_tyrk_heavi_a",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3] ], 
["helm_sel2", "Turk Cavalry Helmet", [("helm_tyrk_heavi_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard  ,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3] ], 
["helm_sel3", "Turk Cavalry Helmet", [("helm_tyrk_heavi_c",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3] ], 

["helm_ayy1", "Arabian Cavalry Helmet", [("gulam_helm_a",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head   ,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 
["helm_ayy2", "Arabian Cavalry Helmet", [("gulam_helm_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 
["helm_ayy3", "Arabian Cavalry Helmet", [("gulam_helm_c",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 
["helm_ayy4", "Arabian Cavalry Helmet", [("gulam_helm_d",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 
["helm_ayy5", "Arabian Cavalry Helmet", [("gulam_helm_f",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_6] ], 

["helmet_lord_sar", "Sultan Helmet", [("helm_Sultan_saracens",0)],  itp_unique|itp_type_head_armor|itp_covers_beard | itp_attach_armature   ,0, 4500 , weight(3)|abundance(0)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_plate, [], [fac_kingdom_3,fac_kingdom_6]],  

#Bandit Helmets

["beduin_turban1", "Turban", [("beduin_turban_a",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],
["beduin_turban2", "Turban", [("beduin_turban_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],
["beduin_turban3", "Turban", [("beduin_turban_c",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard | itp_attach_armature   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],
["beduin_turban4", "Turban", [("beduin_turban_d",0)], itp_merchandise| itp_type_head_armor | itp_fit_to_head | itp_attach_armature   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6] ],

#Mercenary Helmets

["helmet_mercenary1", "Helmet", [("dethertir_helm_b",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]], 
["helmet_mercenary2", "Helmet", [("dethertir_helm_c",0)], itp_merchandise| itp_type_head_armor | itp_covers_beard   ,0, 700 , weight(1.15)|abundance(25)|head_armor(15)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]], 

["helm_mercenary", "Knight Helmet", [("dethertir_helm_a",0)], itp_merchandise| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(10)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_mercenary1", "Infantry Helm", [("dethertir_helm_b",0)], itp_unique| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(0)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   
["helm_mercenary2", "Infantry Helm", [("dethertir_helm_c",0)], itp_unique| itp_type_head_armor|itp_covers_beard,0, 4500 , weight(3)|abundance(0)|head_armor(40)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],   

#Christian Shields

["shield_veteran_jer1", "Jerusalem Shield", [("shield_veteran_jerusalem_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_jer2", "Jerusalem Shield", [("shield_veteran_jerusalem_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_jer3", "Jerusalem Shield", [("shield_veteran_jerusalem_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_jer4", "Jerusalem Shield", [("shield_veteran_jerusalem_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],

["shield_veteran_jer5", "Jerusalem Shield", [("shield_veteran_jerusalem_e",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_jer6", "Jerusalem Shield", [("shield_veteran_jerusalem_f",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_jer7", "Jerusalem Shield", [("shield_veteran_jerusalem_g",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_jer8", "Jerusalem Shield", [("shield_veteran_jerusalem_h",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],

["shield_veteran_ibe1", "Jerusalem Shield", [("shield_veteran_ibelin_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_ibe2", "Jerusalem Shield", [("shield_veteran_ibelin_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_ibe3", "Jerusalem Shield", [("shield_veteran_ibelin_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_ibe4", "Jerusalem Shield", [("shield_veteran_ibelin_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],
["shield_veteran_ibe5", "Jerusalem Shield", [("shield_veteran_ibelin_e",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1]],

["shield_veteran_ant1", "Antioch Shield", [("shield_veteran_antioh_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_ant2", "Antioch Shield", [("shield_veteran_antioh_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_ant3", "Antioch Shield", [("shield_veteran_antioh_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_ant4", "Antioch Shield", [("shield_veteran_antioh_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],

["shield_veteran_ant5", "Antioch Shield", [("shield_veteran_antioh_e",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_ant6", "Antioch Shield", [("shield_veteran_antioh_f",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_ant7", "Antioch Shield", [("shield_veteran_antioh_g",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_ant8", "Antioch Shield", [("shield_veteran_antioh_h",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],

["shield_veteran_tri1", "Antioch Shield", [("shield_veteran_tripoli_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_tri2", "Antioch Shield", [("shield_veteran_tripoli_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_tri3", "Antioch Shield", [("shield_veteran_tripoli_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_tri4", "Antioch Shield", [("shield_veteran_tripoli_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],

["shield_veteran_tri5", "Antioch Shield", [("shield_veteran_tripoli_e",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_tri6", "Antioch Shield", [("shield_veteran_tripoli_f",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_tri7", "Antioch Shield", [("shield_veteran_tripoli_g",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],
["shield_veteran_tri8", "Antioch Shield", [("shield_veteran_tripoli_h",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_2]],

["shield_veteran_tem1", "Templar Shield", [("shield_veteran_templar_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_4]],
["shield_veteran_tem2", "Templar Shield", [("shield_veteran_templar_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_4]],
["shield_veteran_tem3", "Templar Shield", [("shield_veteran_templar_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_4]],
["shield_veteran_tem4", "Templar Shield", [("shield_veteran_templar_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_4]],

["shield_veteran_tem5", "Templar Shield", [("shield_veteran_templar_e",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_4]],
["shield_veteran_tem6", "Templar Shield", [("shield_veteran_templar_f",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_4]],
["shield_veteran_tem7", "Templar Shield", [("shield_veteran_templar_g",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_4]],
["shield_veteran_tem8", "Templar Shield", [("shield_veteran_templar_h",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_4]],

["shield_veteran_hos1", "Hospitaller Shield", [("shield_veteran_hospital_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_5]],
["shield_veteran_hos2", "Hospitaller Shield", [("shield_veteran_hospital_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_5]],
["shield_veteran_hos3", "Hospitaller Shield", [("shield_veteran_hospital_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_5]],
["shield_veteran_hos4", "Hospitaller Shield", [("shield_veteran_hospital_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_5]],

["shield_veteran_hos5", "Hospitaller Shield", [("shield_veteran_hospital_e",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_5]],
["shield_veteran_hos6", "Hospitaller Shield", [("shield_veteran_hospital_f",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_5]],
["shield_veteran_hos7", "Hospitaller Shield", [("shield_veteran_hospital_g",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_5]],
["shield_veteran_hos8", "Hospitaller Shield", [("shield_veteran_hospital_h",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_5]],

["shield_veteran_teu1", "Teutonic Shield", [("shield_veteran_tevton_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_veteran_teu2", "Teutonic Shield", [("shield_veteran_tevton_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_veteran_teu3", "Teutonic Shield", [("shield_veteran_tevton_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_veteran_teu4", "Teutonic Shield", [("shield_veteran_tevton_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],

["shield_veteran_teu5", "Teutonic Shield", [("shield_veteran_tevton_e",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_veteran_teu6", "Teutonic Shield", [("shield_veteran_tevton_f",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_veteran_teu7", "Teutonic Shield", [("shield_veteran_tevton_g",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_veteran_teu8", "Teutonic Shield", [("shield_veteran_tevton_h",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 156, weight(3)|hit_points(265)|body_armor(13)|spd_rtng(90)|shield_width(36)|shield_height(70),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],

["shield_archer_jer1", "Jerusalem Archer Shield", [("shields_archer_jerusalem_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1]],
["shield_archer_jer2", "Jerusalem Archer Shield", [("shields_archer_jerusalem_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1]],
["shield_archer_jer3", "Jerusalem Archer Shield", [("shields_archer_jerusalem_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1]],
["shield_archer_jer4", "Jerusalem Archer Shield", [("shields_archer_jerusalem_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1]],

["shield_archer_ibe1", "Jerusalem Archer Shield", [("shields_archer_ibelin_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1]],
["shield_archer_ibe2", "Jerusalem Archer Shield", [("shields_archer_ibelin_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1]],
["shield_archer_ibe3", "Jerusalem Archer Shield", [("shields_archer_ibelin_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1]],
["shield_archer_ibe4", "Jerusalem Archer Shield", [("shields_archer_ibelin_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1]],

["shield_archer_ant1", "Antioch Archer Shield", [("shields_archer_antioh_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_2]],
["shield_archer_ant2", "Antioch Archer Shield", [("shields_archer_antioh_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_2]],
["shield_archer_ant3", "Antioch Archer Shield", [("shields_archer_antioh_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_2]],
["shield_archer_ant4", "Antioch Archer Shield", [("shields_archer_antioh_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_2]],

["shield_archer_tri1", "Antioch Archer Shield", [("shields_archer_tripoli_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_2]],
["shield_archer_tri2", "Antioch Archer Shield", [("shields_archer_tripoli_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_2]],
["shield_archer_tri3", "Antioch Archer Shield", [("shields_archer_tripoli_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_2]],
["shield_archer_tri4", "Antioch Archer Shield", [("shields_archer_tripoli_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_2]],

["shield_archer_tem1", "Templar Archer Shield", [("shields_archer_templar_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_4]],
["shield_archer_tem2", "Templar Archer Shield", [("shields_archer_templar_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_4]],
["shield_archer_tem3", "Templar Archer Shield", [("shields_archer_templar_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_4]],
["shield_archer_tem4", "Templar Archer Shield", [("shields_archer_templar_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_4]],

["shield_archer_hos1", "Hospitaller Archer Shield", [("shields_archer_hospitaller_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_5]],
["shield_archer_hos2", "Hospitaller Archer Shield", [("shields_archer_hospitaller_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_5]],
["shield_archer_hos3", "Hospitaller Archer Shield", [("shields_archer_hospitaller_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_5]],
["shield_archer_hos4", "Hospitaller Archer Shield", [("shields_archer_hospitaller_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_5]],

["shield_archer_teu1", "Teutonic Archer Shield", [("shields_archer_tevton_a",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_archer_teu2", "Teutonic Archer Shield", [("shields_archer_tevton_b",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_archer_teu3", "Teutonic Archer Shield", [("shields_archer_tevton_c",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_archer_teu4", "Teutonic Archer Shield", [("shields_archer_tevton_d",0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_round_shield, 105, weight(3)|hit_points(215)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],

["shield_knight_jer1", "Jerusalem Knight Shield",   [("Jerusalem_shield_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],
["shield_knight_jer2", "Jerusalem Knight Shield",   [("Jerusalem_shield_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],
["shield_knight_jer3", "Jerusalem Knight Shield",   [("Jerusalem_shield_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],
["shield_knight_jer4", "Jerusalem Knight Shield",   [("Jerusalem_shield_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],

["shield_knight_jer5", "Jerusalem Knight Shield",   [("shield_knight_jerusalem_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],
["shield_knight_jer6", "Jerusalem Knight Shield",   [("shield_knight_jerusalem_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],
["shield_knight_jer7", "Jerusalem Knight Shield",   [("shield_knight_jerusalem_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],
["shield_knight_jer8", "Jerusalem Knight Shield",   [("shield_knight_jerusalem_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],

["shield_knight_ibe1", "Jerusalem Knight Shield",   [("ibelin_shield_knight_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],
["shield_knight_ibe2", "Jerusalem Knight Shield",   [("ibelin_shield_knight_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1]],

["shield_knight_ant1", "Antioch Knight Shield",   [("antioh_shield_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_ant2", "Antioch Knight Shield",   [("antioh_shield_e" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_ant3", "Antioch Knight Shield",   [("antioh_shield_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_ant4", "Antioch Knight Shield",   [("antioh_shield_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_ant5", "Antioch Knight Shield",   [("antioh_shield_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],

["shield_knight_ant6", "Antioch Knight Shield",   [("shield_knight_antioh_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_ant7", "Antioch Knight Shield",   [("shield_knight_antioh_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_ant8", "Antioch Knight Shield",   [("shield_knight_antioh_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_ant9", "Antioch Knight Shield",   [("shield_knight_antioh_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],

["shield_knight_tri1", "Antioch Knight Shield",   [("tripoli_shield_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_tri2", "Antioch Knight Shield",   [("tripoli_shield_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_tri3", "Antioch Knight Shield",   [("tripoli_shield_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_tri4", "Antioch Knight Shield",   [("tripoli_shield_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_tri5", "Antioch Knight Shield",   [("tripoli_shield_e" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],

["shield_knight_tri6", "Antioch Knight Shield",   [("shield_knight_tripoli_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_tri7", "Antioch Knight Shield",   [("shield_knight_tripoli_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_tri8", "Antioch Knight Shield",   [("shield_knight_tripoli_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],
["shield_knight_tri9", "Antioch Knight Shield",   [("shield_knight_tripoli_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_2]],

["shield_knight_tem1", "Templar Knight Shield",   [("templar_shield_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(40)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],
["shield_knight_tem2", "Templar Knight Shield",   [("templar_shield_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(40)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],

["shield_knight_tem3", "Templar Knight Shield",   [("shield_knight_templar_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(40)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],
["shield_knight_tem4", "Templar Knight Shield",   [("shield_knight_templar_f" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(40)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],
["shield_knight_tem5", "Templar Knight Shield",   [("shield_knight_templar_g" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(40)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],
["shield_knight_tem6", "Templar Knight Shield",   [("shield_knight_templar_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(40)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],
["shield_knight_tem7", "Templar Knight Shield",   [("shield_knight_templar_k" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(40)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],

["shield_knight_temconf1", "Templar Knight Shield",   [("templar_shield_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],
["shield_knight_temconf2", "Templar Knight Shield",   [("templar_shield_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],

["shield_knight_temconf3", "Templar Knight Shield",   [("shield_knight_templar_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],
["shield_knight_temconf4", "Templar Knight Shield",   [("shield_knight_templar_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],
["shield_knight_temconf5", "Templar Knight Shield",   [("shield_knight_templar_e" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],
["shield_knight_temconf6", "Templar Knight Shield",   [("shield_knight_templar_h" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_4]],

["shield_knight_hos1", "Hospitaller Knight Shield",   [("hospitaller_shield_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_5]],
["shield_knight_hos2", "Hospitaller Knight Shield",   [("hospitaller_shield_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_5]],

["shield_knight_hos3", "Hospitaller Knight Shield",   [("shield_knight_hospitaller_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_5]],
["shield_knight_hos4", "Hospitaller Knight Shield",   [("shield_knight_hospitaller_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_5]],

["shield_knight_hosconf1", "Hospitaller Knight Shield",   [("hospitaller_shield_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_5]],
["shield_knight_hosconf2", "Hospitaller Knight Shield",   [("hospitaller_shield_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_5]],

["shield_knight_hosconf3", "Hospitaller Knight Shield",   [("shield_knight_hospitaller_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_5]],
["shield_knight_hosconf4", "Hospitaller Knight Shield",   [("shield_knight_hospitaller_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_5]],

["shield_knight_teu1", "Teutonic Knight Shield",   [("tevton_shield_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_knight_teu2", "Teutonic Knight Shield",   [("tevton_shield_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_knight_teu3", "Teutonic Knight Shield",   [("tevton_shield_e" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],

["shield_knight_teu4", "Teutonic Knight Shield",   [("shield_knight_tevton_d" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_knight_teu5", "Teutonic Knight Shield",   [("shield_knight_tevton_e" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_knight_teu6", "Teutonic Knight Shield",   [("shield_knight_tevton_g" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_knight_teu7", "Teutonic Knight Shield",   [("shield_knight_tevton_h" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],

["shield_knight_teuconf1", "Teutonic Knight Shield",   [("tevton_shield_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_knight_teuconf2", "Teutonic Knight Shield",   [("tevton_shield_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],

["shield_knight_teuconf3", "Teutonic Knight Shield",   [("shield_knight_tevton_a" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_knight_teuconf4", "Teutonic Knight Shield",   [("shield_knight_tevton_b" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_knight_teuconf5", "Teutonic Knight Shield",   [("shield_knight_tevton_c" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],
["shield_knight_teuconf6", "Teutonic Knight Shield",   [("shield_knight_tevton_f" ,0)], itp_merchandise|itp_type_shield|itp_wooden_parry, itcf_carry_kite_shield, 390, weight(2.5)|hit_points(220)|body_armor(23)|spd_rtng(100)|shield_width(30)|shield_height(50),imodbits_shield, [], [fac_kingdom_1,fac_kingdom_2]],

["securiti_shield_jer", "Jerusalem Guard Shield", [("securiti_caravan_crusader_shield",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 500, weight(3.5)|hit_points(310)|body_armor(16)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_1]],

#Muslim Shields 

["shield_sar1", "Arabian Shield", [("saracin_shield_c",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_sar2", "Arabian Shield", [("saracin_shield_g",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_sar3", "Arabian Shield", [("saracin_shield_h",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_sar4", "Arabian Shield", [("saracin_shield_k",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_sar5", "Arabian Shield", [("saracin_shield_l",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],

["shield_sar6", "Arabian Shield", [("saracin_shield_q",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_sar7", "Arabian Shield", [("saracin_shield_r",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_sar8", "Arabian Shield", [("saracin_shield_s",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_sar9", "Arabian Shield", [("saracin_shield_v",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_sar10", "Arabian Shield", [("saracin_shield_t",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],

["shield_ayyinf1", "Arabian Oval Shield", [("saracin_shield_a",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(16)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_ayyinf2", "Arabian Oval Shield", [("saracin_shield_b",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(16)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_ayyinf3", "Arabian Oval Shield", [("saracin_shield_f",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(16)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_ayyinf4", "Arabian Oval Shield", [("saracin_shield_m",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(16)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_ayyinf5", "Arabian Oval Shield", [("saracin_shield_n",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(16)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],

#["shield_sel1", "Shield", [("shield_vostoka_a",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  105 , weight(3.5)|hit_points(310)|body_armor(16)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3]],   
#["shield_sel2", "Shield", [("shield_vostoka_b",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  105 , weight(3.5)|hit_points(310)|body_armor(16)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3]],   
#["shield_sel3", "Shield", [("shield_vostoka_c",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  105 , weight(3.5)|hit_points(310)|body_armor(16)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3]],   

["shield_ayycav1", "Arabian Shield", [("saracin_shield_d",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  105 , weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],   
["shield_ayycav2", "Arabian Shield", [("saracin_shield_y",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  105 , weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],   
["shield_ayycav3", "Arabian Shield", [("saracin_shield_e",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  105 , weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],   
["shield_ayycav4", "Arabian Shield", [("saracin_shield_w",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  105 , weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],   
["shield_ayycav5", "Arabian Shield", [("saracin_shield_p",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield,  105 , weight(3)|hit_points(310)|body_armor(12)|spd_rtng(95)|shield_width(30),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],   

#Bandit Shields

["shield_bandit1", "Arabian Shield", [("bandit_shield_a",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(12)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_bandit2", "Arabian Shield", [("bandit_shield_b",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(12)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_bandit3", "Arabian Shield", [("bandit_shield_c",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(12)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_bandit4", "Arabian Shield", [("bandit_shield_d",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(12)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_bandit5", "Arabian Shield", [("bandit_shield_e",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(12)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],
["shield_bandit6", "Arabian Shield", [("bandit_shield_f",0)], itp_merchandise|itp_type_shield, itcf_carry_round_shield, 105, weight(3.5)|hit_points(310)|body_armor(12)|spd_rtng(87)|shield_width(50),imodbits_shield, [], [fac_kingdom_3,fac_kingdom_6]],

#Christian Horses

["horse_jer_lord","Jerusalem King Horse", [("Jerusalem_king_horse",0)], itp_unique|itp_type_horse, 0, 810,abundance(0)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1]],
["horse_tem_lord","Templar Grandmaster Horse", [("horse_master_order_templar",0)], itp_unique|itp_type_horse, 0, 810,abundance(0)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_4]],
["horse_hos_lord","Hospitaller Grandmaster Horse", [("horse_master_order_hospitaller",0)], itp_unique|itp_type_horse, 0, 810,abundance(0)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_5]],
["horse_teu_lord","Teutonic Grandmaster Horse", [("horse_master_order_tevton",0)], itp_merchandise|itp_type_horse, 0, 5000,abundance(10)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2]],

["horse_jer1","Jerusalem Horse", [("Jerusalem_knight_horse_b",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1]],
["horse_jer2","Jerusalem Horse", [("Jerusalem_knight_horse_a",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1]],
["horse_jer3","Jerusalem Horse", [("Jerusalem_knight_horse_c",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1]],

["horse_ibe1","Jerusalem Horse", [("ibelin_knight_horse_a",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1]],
["horse_ibe2","Jerusalem Horse", [("ibelin_knight_horse_b",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1]],
["horse_ibe3","Jerusalem Horse", [("ibelin_knight_horse_c",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1]],

["horse_ant1","Antioch Horse", [("antiohia_knight_horse_a",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_2]],
["horse_ant2","Antioch Horse", [("antiohia_knight_horse_b",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_2]],

["horse_tri1","Antioch Horse", [("tripoli_knight_horse_a",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_2]],
["horse_tri2","Antioch Horse", [("tripoli_knight_horse_b",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_2]],
["horse_tri3","Antioch Horse", [("tripoli_knight_horse_c",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_2]],

["horse_tem1","Templar Horse", [("templar_knight_horse_a",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_4]],
["horse_tem2","Templar Horse", [("templar_knight_horse_b",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_4]],
["horse_tem3","Templar Horse", [("templar_knight_horse_e",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_4]],

["horse_tem_conf1","Templar Horse", [("templar_knight_horse_c",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_4]],
["horse_tem_conf2","Templar Horse", [("templar_knight_horse_d",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_4]],

["horse_hos1","Hospitaller Horse", [("hospitaller_knight_horse_c",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_5]],
["horse_hos2","Hospitaller Horse", [("hospitaller_knight_horse_d",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_5]],

["horse_hos_conf1","Hospitaller Horse", [("hospitaller_knight_horse_a",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_5]],
["horse_hos_conf2","Hospitaller Horse", [("hospitaller_knight_horse_b",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_5]],

["horse_teu1","Teutonic Horse", [("tevton_knight_horse_a",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2]],
["horse_teu2","Teutonic Horse", [("tevton_knight_horse_d",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2]],

["horse_teu_conf1","Teutonic Horse", [("tevton_knight_horse_b",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2]],
["horse_teu_conf2","Teutonic Horse", [("tevton_knight_horse_c",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2]],

["hunter1","European Horse", [("European_horse_a",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["hunter2","European Horse", [("European_horse_b",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["hunter3","European Horse", [("European_horse_d",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["hunter4","European Horse", [("European_horse_e",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["hunter5","European Horse", [("European_horse_c",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["hunter6","European Horse", [("European_horse_f",0)], itp_merchandise|itp_type_horse, 0, 810,abundance(15)|hit_points(160)|body_armor(18)|difficulty(0)|horse_speed(43)|horse_maneuver(44)|horse_charge(24)|horse_scale(108),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

#Muslim Horses

["horse_sel_lord","Sultan Horse", [("saracin_hard_horses_d",0)], itp_unique|itp_type_horse, 0, 850,abundance(0)|hit_points(130)|body_armor(13)|difficulty(0)|horse_speed(43)|horse_maneuver(50)|horse_charge(19)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3]],
["horse_ayy_lord","Sultan Horse", [("saracen_horse_Sultan",0)], itp_unique|itp_type_horse, 0, 850,abundance(0)|hit_points(130)|body_armor(13)|difficulty(0)|horse_speed(43)|horse_maneuver(50)|horse_charge(19)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_6]],

["arabian_cav1","Arabian War Horse", [("saracin_hard_horses_a",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(130)|body_armor(13)|difficulty(0)|horse_speed(43)|horse_maneuver(50)|horse_charge(19)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],
["arabian_cav2","Arabian War Horse", [("saracin_hard_horses_a_v1",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(130)|body_armor(13)|difficulty(0)|horse_speed(43)|horse_maneuver(50)|horse_charge(19)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],
["arabian_cav3","Arabian War Horse", [("saracin_hard_horses_b",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(130)|body_armor(13)|difficulty(0)|horse_speed(43)|horse_maneuver(50)|horse_charge(19)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],
["arabian_cav4","Arabian War Horse", [("saracin_hard_horses_b_v1",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(130)|body_armor(13)|difficulty(0)|horse_speed(43)|horse_maneuver(50)|horse_charge(19)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],
["arabian_cav5","Arabian War Horse", [("saracin_hard_horses_c",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(130)|body_armor(13)|difficulty(0)|horse_speed(43)|horse_maneuver(50)|horse_charge(19)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],
["arabian_cav6","Arabian War Horse", [("saracin_hard_horses_c_v1",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(130)|body_armor(13)|difficulty(0)|horse_speed(43)|horse_maneuver(50)|horse_charge(19)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],
["arabian_cav7","Arabian War Horse", [("saracin_hard_horses_d_v1",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(130)|body_armor(13)|difficulty(0)|horse_speed(43)|horse_maneuver(50)|horse_charge(19)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],

["turk1","Turk Horse", [("horse_tyrk_a",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3]],
["turk2","Turk Horse", [("horse_tyrk_b",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3]],
["turk3","Turk Horse", [("horse_tyrk_c",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3]],
["turk4","Turk Horse", [("horse_tyrk_d",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3]],
["turk5","Turk Horse", [("horse_tyrk_a",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3]],

["arabian1","Arabian Horse", [("arabs_horse_1",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_6]],
["arabian2","Arabian Horse", [("arabs_horse_2",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_6]],
["arabian3","Arabian Horse", [("arabs_horse_3",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_6]],
["arabian4","Arabian Horse", [("arabs_horse_4",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_6]],

["arabian_bandit1","Arabian Nomad Horse", [("bandits_horse_a",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],
["arabian_bandit2","Arabian Nomad Horse", [("bandits_horse_b",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],
["arabian_bandit3","Arabian Nomad Horse", [("bandits_horse_c",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],
["arabian_bandit4","Arabian Nomad Horse", [("bandits_horse_d",0)], itp_merchandise|itp_type_horse, 0, 850,abundance(15)|hit_points(120)|body_armor(10)|difficulty(0)|horse_speed(43)|horse_maneuver(54)|horse_charge(16)|horse_scale(104),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],

["camel","Camel", [("bedyin_camel_a",0)], itp_merchandise|itp_type_horse, 0, 490,abundance(15)|hit_points(200)|body_armor(25)|difficulty(0)|horse_speed(38)|horse_maneuver(38)|horse_charge(10)|horse_scale(123),imodbits_horse_basic|imodbit_champion, [], [fac_kingdom_3, fac_kingdom_6]],

#Muslim and Christian Horses

["saddle_horse1","Horse", [("horse_bandits_a",0),("horse_c",imodbits_horse_good)], itp_merchandise|itp_type_horse, 0, 240,abundance(50)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
["saddle_horse2","Horse", [("horse_bandits_b",0),("horse_c",imodbits_horse_good)], itp_merchandise|itp_type_horse, 0, 240,abundance(50)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
["saddle_horse3","Horse", [("horse_bandits_c",0),("horse_c",imodbits_horse_good)], itp_merchandise|itp_type_horse, 0, 240,abundance(50)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],
["saddle_horse4","Horse", [("horse_bandits_d",0),("horse_c",imodbits_horse_good)], itp_merchandise|itp_type_horse, 0, 240,abundance(50)|hit_points(100)|body_armor(8)|difficulty(0)|horse_speed(40)|horse_maneuver(40)|horse_charge(10)|horse_scale(108),imodbit_champion],

#Christian Gloves and Boots

["mail_mittens1","Mail Mittens", [("gauntlets_crysader_L",0)], itp_merchandise| itp_type_hand_armor,0, 350, weight(0.5)|abundance(15)|body_armor(4)|difficulty(0),imodbits_armor, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["boots_light_cru1", "Light Boots", [("boot_light_crusader_a",0)], itp_merchandise| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 75 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["boots_light_cru2", "Light Boots", [("boot_light_crusader_b",0)], itp_merchandise| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 75 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["boots_light_cru3", "Light Boots", [("boot_light_crusader_c",0)], itp_merchandise| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 75 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["boots_light_cru4", "Light Boots", [("boot_light_crusader_d",0)], itp_merchandise| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 75 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["boots_average_cru1", "Leather Boots", [("boot_average_crusader_a",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(25)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["boots_average_cru2", "Leather Boots", [("boot_average_crusader_b",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(25)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["boots_average_cru3", "Leather Boots", [("boot_average_crusader_c",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(25)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["boots_average_cru4", "Leather Boots", [("boot_average_crusader_d",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(25)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["securiti_boots_jer", "Jerusalem Guard Boots", [("civil_rich_Boots_b",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(25)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_1]],

["mail_boots2", "Mail Chausses", [("shoes_crusader",0)],  itp_merchandise| itp_type_foot_armor | itp_attach_armature  ,0, 530 , weight(3)|abundance(15)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],
["mail_boots1", "Knight Mail Chausses", [("shoes_crusader_knight",0)],  itp_merchandise| itp_type_foot_armor | itp_attach_armature  ,0, 530 , weight(3)|abundance(15)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["monk_boots", "Mail Chausses", [("shoes_crusader",0)],  itp_unique| itp_type_foot_armor | itp_attach_armature  ,0, 530 , weight(3)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor , [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5]],

["special_boots_jer", "Jerusalem Palace Boots", [("civil_rich_Boots_b",0)], itp_unique| itp_type_foot_armor  |itp_attach_armature,0, 530 , weight(3)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor , [], [fac_kingdom_1]],

#Muslim Gloves and Boots

["gauntlets_sar1","Gauntlets", [("gauntlets_arabs_a_L",0)], itp_merchandise| itp_type_hand_armor,0, 350, weight(0.5)|abundance(15)|body_armor(4)|difficulty(0),imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]],
["gauntlets_sar2","Gauntlets", [("gauntlets_arabs_b_L",0)], itp_merchandise| itp_type_hand_armor,0, 350, weight(0.5)|abundance(15)|body_armor(4)|difficulty(0),imodbits_armor, [], [fac_kingdom_3,fac_kingdom_6]],

["boots_light_sar1", "Arabian Light Boots", [("saracin_light_boot_a",0)], itp_merchandise| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 75 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_3,fac_kingdom_6]],
["boots_light_sar2", "Arabian Light Boots", [("saracin_light_boot_b",0)], itp_merchandise| itp_type_foot_armor |itp_civilian  | itp_attach_armature,0, 75 , weight(1)|abundance(50)|head_armor(0)|body_armor(0)|leg_armor(12)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_3,fac_kingdom_6]],

["boots_average_sar1", "Arabian Leather Boots", [("saracin_medium_boot_a",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(25)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_3,fac_kingdom_6]],
["boots_average_sar2", "Arabian Leather Boots", [("saracin_medium_boot_b",0)], itp_merchandise| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(25)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth , [], [fac_kingdom_3,fac_kingdom_6]],

["boots_cav_sel1", "Turk Cavalry Boots", [("boots_tyrk_a",0)],  itp_merchandise| itp_type_foot_armor | itp_attach_armature  ,0, 530 , weight(3)|abundance(15)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor , [], [fac_kingdom_3]],
["boots_cav_sel2", "Turk Cavalry Boots", [("boots_tyrk_b",0)],  itp_merchandise| itp_type_foot_armor | itp_attach_armature  ,0, 530 , weight(3)|abundance(15)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor , [], [fac_kingdom_3]],
["boots_cav_sel3", "Turk Cavalry Boots", [("boots_tyrk_c",0)],  itp_merchandise| itp_type_foot_armor | itp_attach_armature  ,0, 530 , weight(3)|abundance(15)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor , [], [fac_kingdom_3]],

["boots_cav_ayy1", "Arabian Cavalry Boots", [("saracin_hard_boot_a",0)],  itp_merchandise| itp_type_foot_armor | itp_attach_armature  ,0, 530 , weight(3)|abundance(15)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor , [], [fac_kingdom_6]],
["boots_cav_ayy2", "Arabian Cavalry Boots", [("saracin_hard_boot_b",0)],  itp_merchandise| itp_type_foot_armor | itp_attach_armature  ,0, 530 , weight(3)|abundance(15)|head_armor(0)|body_armor(0)|leg_armor(24)|difficulty(0) ,imodbits_armor , [], [fac_kingdom_6]],

#Lords Courtly Outfit

["courtly_mask_jer", "Courtly Baldwin Mask", [("yelushaleng",0)], itp_unique| itp_type_head_armor  | itp_fit_to_head  |itp_civilian ,0, 1 , weight(0.5)|abundance(0)|head_armor(4)|body_armor(0)|leg_armor(0)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1]],

["courtly_mail_boots", "Courtly Boots", [("shoes_crusader_knight",0)], itp_unique| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2,fac_kingdom_4,fac_kingdom_5] ],
["courtly_saracen_boots", "Courtly Boots", [("saracin_hard_boot_b",0)], itp_unique| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_6] ],
["courtly_seljuk_boots", "Courtly Boots", [("boots_tyrk_a",0)], itp_unique| itp_type_foot_armor  |itp_civilian | itp_attach_armature,0, 174 , weight(1.25)|abundance(0)|head_armor(0)|body_armor(0)|leg_armor(16)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3] ],

["courtly_outfit_teu", "Courtly Outfit", [("knight_armor_tevton_a_1_cloak",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1,fac_kingdom_2] ],

["courtly_outfit_jer", "Courtly Outfit", [("knight_armor_jerusalem_b_cloak",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1] ],
["courtly_outfit_ant", "Courtly Outfit", [("knight_armor_antioh_d_cloak",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_2] ],
["courtly_outfit_tem", "Courtly Outfit", [("knight_armor_templar_a_1_cloak",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_4] ],
["courtly_outfit_hos", "Courtly Outfit", [("knight_armor_hospitaller_d_cloak",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_5] ],
["courtly_outfit_ayy", "Courtly Outfit", [("Ghulam_heavy_cavalryman_2",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_6] ],
["courtly_outfit_sel", "Courtly Outfit", [("tyrk_armor_heavi_c",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_3] ],

["courtly_outfit_baldwin", "Courtly Outfit", [("armor_king_Jerusalem",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_1] ],
["courtly_master_tem", "Courtly Outfit", [("armor_master_order_templar",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_4] ],
["courtly_master_hos", "Courtly Outfit", [("armor_master_order_hospitaller",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_5] ],
["courtly_outfit_saladin", "Courtly Outfit", [("armor_Sultan_saracens",0)], itp_unique| itp_type_body_armor|itp_covers_legs|itp_civilian   ,0, 348 , weight(4)|abundance(0)|head_armor(0)|body_armor(14)|leg_armor(10)|difficulty(0) ,imodbits_cloth, [], [fac_kingdom_6] ],

["arena_horse_red","Arena_Horse_Red", [("horse_bandits_d",0),("horse_c",imodbits_horse_good)], itp_type_horse, 0, 240,abundance(90)|hit_points(120)|body_armor(8)|difficulty(0)|horse_speed(45)|horse_maneuver(44)|horse_charge(10)|horse_scale(104),imodbits_horse_basic],
["arena_horse_blue","Arena_Horse_Blue", [("horse_bandits_b",0),("horse_c",imodbits_horse_good)], itp_type_horse, 0, 240,abundance(90)|hit_points(120)|body_armor(8)|difficulty(0)|horse_speed(45)|horse_maneuver(44)|horse_charge(10)|horse_scale(104),imodbits_horse_basic],
["arena_horse_green","Arena_Horse_Green", [("horse_bandits_a",0),("horse_c",imodbits_horse_good)], itp_type_horse, 0, 240,abundance(90)|hit_points(120)|body_armor(8)|difficulty(0)|horse_speed(45)|horse_maneuver(44)|horse_charge(10)|horse_scale(104),imodbits_horse_basic],
["arena_horse_yellow","Arena_Horse_Yellow", [("horse_bandits_c",0),("horse_c",imodbits_horse_good)], itp_type_horse, 0, 240,abundance(90)|hit_points(120)|body_armor(8)|difficulty(0)|horse_speed(45)|horse_maneuver(44)|horse_charge(10)|horse_scale(104),imodbits_horse_basic],

["colored_lance_a", "Black_Colored_Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_cutting_spear, 360 , weight(2.75)|difficulty(10)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm ],
["colored_lance_b", "White_Colored_Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_cutting_spear, 360 , weight(2.75)|difficulty(10)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm ],
["colored_lance_f", "Blue_Colored_Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_cutting_spear, 360 , weight(2.75)|difficulty(10)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm ],
["colored_lance_g", "Red_Colored_Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance| itp_primary|itp_penalty_with_shield|itp_wooden_parry, itc_cutting_spear, 360 , weight(2.75)|difficulty(10)|spd_rtng(75) | weapon_length(190)|swing_damage(16 , blunt) | thrust_damage(26 ,  pierce),imodbits_polearm ],
["tutorial_lance", "Tourney_Lance", [("crusader_knight_spear_a",0)], itp_couchable|itp_type_polearm|itp_offset_lance|itp_primary|itp_penalty_with_shield|itp_wooden_parry|itp_crush_through, itc_cutting_spear, 180 , weight(2.5)|difficulty(0)|spd_rtng(85) | weapon_length(175)|swing_damage(10 , blunt) | thrust_damage(21 ,  pierce),imodbits_polearm ],


["bb_templar_sword_a", "Sword", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high ],
["bb_templar_sword_b", "Sword", [("crusader_long_sword_b",0),("crusader_long_sword_b_scabbard", ixmesh_carry)], itp_type_one_handed_wpn|itp_unique|itp_primary, itc_longsword|itcf_carry_sword_left_hip|itcf_show_holster_when_drawn, 163 , weight(1.5)|difficulty(0)|spd_rtng(99) | weapon_length(95)|swing_damage(27 , cut) | thrust_damage(22 ,  pierce),imodbits_sword_high ],

["tutorial_two_handed_sword", "Two_Handed_Sword", [("crusader_long_sword_b",0)], itp_type_two_handed_wpn|itp_two_handed|itp_primary, itc_greatsword|itcf_carry_sword_back, 670 , weight(2.75)|difficulty(0)|spd_rtng(97) | weapon_length(110)|swing_damage(23 , cut) | thrust_damage(20 ,  pierce),imodbits_sword_high ],


["items_end", "Items End", [("shield_round_a",0)], 0, 0, 1, 0, 0],
]
# modmerger_start version=201 type=2
try:
    component_name = "items"
    var_set = { "items" : items }
    from modmerger import modmerge
    modmerge(var_set)
except:
    raise
# modmerger_end
